/*
 * Decompiled with CFR 0.152.
 */
package com.joanju;

import com.joanju.Xferable;
import com.joanju.proparse.IntegerIndex;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DataXferStream {
    private int indexOffset;
    private int schemaMapOffset;
    private IntegerIndex<Object> objectIndexes = new IntegerIndex();
    private HashMap<Integer, Integer> index2offset = new HashMap();
    private HashSet<Xferable> classExamples = new HashSet();
    private HashSet<Object> queue = new HashSet();
    private ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private DataOutputStream out = new DataOutputStream(this.bytes);
    private static final byte XNULL = 2;
    private static final byte XINT = 4;
    private static final byte XSTRING = 6;
    private static final byte XLIST = 8;
    private static final byte XMAP = 10;
    private static final byte XOBJECT = 12;
    private static final byte XTRUE = 14;
    private static final byte XBOOL = 15;
    private static final byte XFALSE = 16;
    private static final byte XNOREP = 18;
    private static final byte XSCHEMA = 20;
    private static final byte XSCHEMA_END = 22;

    public void addSchemaFor(Xferable x) {
        this.classIndex(x);
    }

    public void buildIndexes() throws IOException {
        TreeMap<Integer, Integer> schemaRecordOffsets = new TreeMap<Integer, Integer>();
        for (Xferable xferable : this.classExamples) {
            Class<?> clas = xferable.getClass();
            int index = this.objectIndexes.getIndex(clas);
            int offset = this.out.size();
            this.index2offset.put(index, offset);
            schemaRecordOffsets.put(index, offset);
            this.writeSchemaRecord(clas, xferable);
        }
        this.processQueue();
        this.schemaMapOffset = this.out.size();
        this.out.writeInt(schemaRecordOffsets.size());
        for (Map.Entry entry : schemaRecordOffsets.entrySet()) {
            this.out.writeInt((Integer)entry.getKey());
            this.out.writeInt((Integer)entry.getValue());
        }
        this.indexOffset = this.out.size();
        int n = this.objectIndexes.size();
        this.out.writeInt(n);
        int i = 0;
        while (i < n) {
            Integer offset = this.index2offset.get(i);
            this.out.writeInt(offset != null ? offset : -1);
            ++i;
        }
        this.out.writeInt(this.schemaMapOffset);
        this.out.writeInt(this.indexOffset);
    }

    private int classIndex(Xferable x) {
        Class<?> clas = x.getClass();
        int classIndex = this.objectIndexes.getIndex(clas);
        if (classIndex == -1) {
            classIndex = this.objectIndexes.add(clas);
            this.classExamples.add(x);
        }
        return classIndex;
    }

    public ByteArrayOutputStream getBytes() {
        return this.bytes;
    }

    public int getIndexOffset() {
        return this.indexOffset;
    }

    public int getSchemaMapOffset() {
        return this.schemaMapOffset;
    }

    public int getOffsetOf(Object o) throws IOException {
        int index = this.objectIndexes.getIndex(o);
        if (index == -1) {
            return -1;
        }
        Integer ret = this.index2offset.get(index);
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    private int indexAndQueue(Object o) {
        int index = this.objectIndexes.add(o);
        if (!this.index2offset.containsKey(index)) {
            this.queue.add(o);
        }
        return index;
    }

    private void processQueue() throws IOException {
        while (this.queue.size() > 0) {
            Iterator<Object> it = this.queue.iterator();
            Object obj = it.next();
            it.remove();
            this.writeObjectRecord(obj);
        }
    }

    public void schemaBool(String fieldName) throws IOException {
        this.out.writeByte(15);
        this.writeRef(fieldName);
    }

    public void schemaInt(String fieldName) throws IOException {
        this.out.writeByte(4);
        this.writeRef(fieldName);
    }

    public void schemaRef(String fieldName) throws IOException {
        this.out.writeByte(12);
        this.writeRef(fieldName);
    }

    public int size() {
        return this.out.size();
    }

    public int store(Object o) throws IOException {
        int ret = this.bytes.size();
        this.writeObjectRecord(o);
        this.processQueue();
        return ret;
    }

    public void writeBool(boolean b) throws IOException {
        this.out.writeByte(b ? 14 : 16);
    }

    private void writeBooleanRecord(Boolean b) throws IOException {
        this.out.writeByte(b != false ? 14 : 16);
    }

    public void writeInt(int i) throws IOException {
        this.out.writeInt(i);
    }

    private void writeIntegerRecord(Integer i) throws IOException {
        this.out.writeByte(4);
        this.out.writeInt(i);
    }

    private void writeList(List list) throws IOException {
        this.out.writeInt(list.size());
        for (Object o : list) {
            this.writeRef(o);
        }
    }

    private void writeListRecord(List list) throws IOException {
        this.out.writeByte(8);
        this.writeList(list);
    }

    private void writeMap(Map map) throws IOException {
        this.out.writeInt(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            this.writeRef(entry.getKey());
            this.writeRef(entry.getValue());
        }
    }

    private void writeMapRecord(Map map) throws IOException {
        this.out.writeByte(10);
        this.writeMap(map);
    }

    private void writeNoRepRecord(Object o) throws IOException {
        this.out.writeByte(18);
        this.out.writeInt(this.indexAndQueue(o.getClass().getName()));
    }

    private void writeNullRecord() throws IOException {
        this.out.writeByte(2);
    }

    private void writeObjectRecord(Object o) throws IOException {
        int index = this.objectIndexes.getIndex(o);
        this.index2offset.put(index, this.out.size());
        if (o == null) {
            this.writeNullRecord();
        } else if (o instanceof Integer) {
            this.writeIntegerRecord((Integer)o);
        } else if (o instanceof Boolean) {
            this.writeBooleanRecord((Boolean)o);
        } else if (o instanceof String) {
            this.writeStringRecord((String)o);
        } else if (o instanceof Xferable) {
            this.writeXferableRecord((Xferable)o);
        } else if (o instanceof Map) {
            this.writeMapRecord((Map)o);
        } else if (o instanceof List) {
            this.writeListRecord((List)o);
        } else if (o.getClass().isArray()) {
            this.writeListRecord(Arrays.asList((Object[])o));
        } else if (o instanceof Set) {
            this.writeListRecord(Arrays.asList(((Set)o).toArray()));
        } else {
            this.writeNoRepRecord(o);
        }
    }

    public void writeRef(Object o) throws IOException {
        if (o == null) {
            this.out.writeInt(-1);
        } else {
            this.out.writeInt(this.indexAndQueue(o));
        }
    }

    private void writeSchemaRecord(Class clas, Xferable example) throws IOException {
        this.out.writeByte(20);
        this.writeString(clas.getName());
        example.writeXferSchema(this);
        this.out.writeByte(22);
    }

    private void writeString(String s) throws IOException {
        byte[] b = s.getBytes();
        this.out.writeInt(b.length);
        this.out.write(b);
    }

    private void writeStringRecord(String s) throws IOException {
        this.out.writeByte(6);
        this.writeString(s);
    }

    private void writeXferableRecord(Xferable x) throws IOException {
        this.out.writeByte(12);
        this.out.writeInt(this.classIndex(x));
        x.writeXferBytes(this);
    }
}

