/*
 * Decompiled with CFR 0.152.
 */
package com.joanju.proparse;

import com.joanju.proparse.Environment;
import java.util.ArrayList;
import java.util.HashMap;

public class ClassFinder {
    Environment environment = Environment.instance();
    ArrayList<String> paths = new ArrayList();
    HashMap<String, String> namesMap = new HashMap();

    void addPath(String nodeText) {
        String dequoted = ClassFinder.dequote(nodeText);
        if (dequoted.length() == 0) {
            return;
        }
        if (dequoted.endsWith("*")) {
            this.paths.add(dequoted.replace('.', '/').substring(0, dequoted.length() - 1));
        } else {
            int dotPos = dequoted.lastIndexOf(46);
            String unqualified = dotPos > 0 ? dequoted.substring(dotPos + 1) : dequoted;
            if (!this.namesMap.containsKey(unqualified = unqualified.toLowerCase())) {
                this.namesMap.put(unqualified, dequoted);
            }
        }
    }

    static String dequote(String s1) {
        StringBuilder s2 = new StringBuilder();
        int len = s1.length();
        char[] c1 = s1.toCharArray();
        int numQuotes = 0;
        int i = 0;
        while (i < len) {
            char c = c1[i];
            if (c == '\"' || c == '\'') {
                if (++numQuotes > 1 && i + 1 < len && c1[i + 1] == ':') {
                    break;
                }
            } else {
                s2.append(c);
            }
            ++i;
        }
        return s2.toString();
    }

    String findClassFile(String qualClassName) {
        String slashName = qualClassName.replace('.', '/');
        return this.environment.findFile(String.valueOf(slashName) + ".cls");
    }

    String lookup(String rawRefName) {
        String dequotedName = ClassFinder.dequote(rawRefName);
        if (dequotedName.contains(".")) {
            return dequotedName;
        }
        String ret = this.namesMap.get(dequotedName.toLowerCase());
        if (ret != null) {
            return ret;
        }
        String withExtension = String.valueOf(dequotedName) + ".cls";
        for (String path : this.paths) {
            String classFile = this.environment.findFile(String.valueOf(path) + withExtension);
            if (classFile.length() == 0) continue;
            ret = String.valueOf(path.replace('/', '.')) + dequotedName;
            this.namesMap.put(dequotedName.toLowerCase(), ret);
            return ret;
        }
        if (this.environment.findFile(String.valueOf(dequotedName) + ".cls").length() > 0) {
            this.namesMap.put(dequotedName.toLowerCase(), dequotedName);
            return dequotedName;
        }
        return "";
    }
}

