/*
 * Decompiled with CFR 0.152.
 */
package com.joanju.proparse;

import com.joanju.proparse.SymbolScope;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.prorefactor.refactor.RefactorSession;

public class Environment {
    boolean proparseDirectives = true;
    int opsysNum = 1;
    String batchMode = "NO";
    String keywordAll;
    String listingFile;
    private boolean multiParse = false;
    String opsys = "WIN32";
    String proparseDirectivesText;
    String proversion;
    String warning;
    String windowSystem = "MS-WIN95";
    ArrayList<String> path = new ArrayList();
    private HashMap<String, SymbolScope> superCache = new HashMap();
    public static final int OPSYS_WINDOWS = 1;
    public static final int OPSYS_UNIX = 2;
    private static Environment instance = null;
    private static HashSet<String> validFlags = new HashSet();

    static {
        validFlags.addAll(Arrays.asList("batch-mode", "keyword-all", "listing-file", "multi-parse", "opsys", "propath", "proversion", "show-proparse-directives", "window-system"));
    }

    void addToSuperCache(String name, SymbolScope scope) {
        this.superCache.put(name.toLowerCase(), scope);
    }

    void addToPath(String dirName) {
        this.path.add(dirName);
    }

    void clearSuperCache() {
        this.superCache.clear();
    }

    boolean configIsValidFlag(String flag) {
        return validFlags.contains(flag.trim().toLowerCase());
    }

    public String configGet(String flag) {
        if ((flag = flag.trim().toLowerCase()).equals("batch-mode")) {
            return this.batchMode;
        }
        if (flag.equals("keyword-all")) {
            return this.keywordAll;
        }
        if (flag.equals("listing-file")) {
            return this.listingFile;
        }
        if (flag.equals("multi-parse")) {
            return this.multiParse ? "true" : "false";
        }
        if (flag.equals("opsys")) {
            return this.opsys;
        }
        if (flag.equals("propath")) {
            String retpath = "";
            boolean delim = false;
            for (String p : this.path) {
                if (delim) {
                    retpath = String.valueOf(retpath) + ",";
                }
                retpath = String.valueOf(retpath) + p;
                delim = true;
            }
            return retpath;
        }
        if (flag.equals("proversion")) {
            return this.proversion;
        }
        if (flag.equals("show-proparse-directives")) {
            return this.proparseDirectivesText;
        }
        if (flag.equals("window-system")) {
            return this.windowSystem;
        }
        return "";
    }

    public void configSet(String flag, String val) {
        RefactorSession refactorSession = RefactorSession.getInstance();
        if ((flag = flag.trim().toLowerCase()).equals("batch-mode")) {
            this.batchMode = val;
            refactorSession.getProgressSettings().batchmode = this.configValToBool(val);
        } else if (flag.equals("keyword-all")) {
            this.keywordAll = val;
            refactorSession.getProparseSettings().keywordall = val;
        } else if (flag.equals("listing-file")) {
            this.listingFile = val;
        } else if (flag.equals("multi-parse")) {
            this.multiParse = this.configValToBool(val);
        } else if (flag.equals("opsys")) {
            refactorSession.getProgressSettings().opsys = val;
            this.opsys = val;
            this.opsysNum = val.trim().toLowerCase().equals("unix") ? 2 : 1;
        } else if (flag.equals("propath")) {
            refactorSession.getProgressSettings().propath = val;
            this.path.clear();
            this.path.addAll(Arrays.asList(val.split(",")));
        } else if (flag.equals("proversion")) {
            refactorSession.getProgressSettings().proversion = val;
            this.proversion = val;
        } else if (flag.equals("show-proparse-directives")) {
            this.proparseDirectivesText = val;
            this.proparseDirectives = this.configValToBool(val);
        } else if (flag.equals("window-system")) {
            refactorSession.getProgressSettings().windowSystem = val;
            this.windowSystem = val;
        }
    }

    boolean configValToBool(String val) {
        String s = val.trim().toLowerCase();
        return s.equals("true") || s.equals("yes");
    }

    String findFile(String fileName) {
        int len = fileName.length();
        if ((len > 0 && (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') || len > 1 && fileName.charAt(1) == ':' || len > 1 && fileName.charAt(0) == '.') && new File(fileName).exists()) {
            return fileName;
        }
        for (String p : this.path) {
            String tryPath = String.valueOf(p) + File.separatorChar + fileName;
            if (!new File(tryPath).exists()) continue;
            return tryPath;
        }
        return "";
    }

    public static Environment instance() {
        if (instance == null) {
            instance = new Environment();
        }
        return instance;
    }

    boolean isMultiParse() {
        return this.multiParse;
    }

    SymbolScope lookupSuper(String superName) {
        return this.superCache.get(superName.toLowerCase());
    }
}

