/*
 * Decompiled with CFR 0.152.
 */
package com.joanju.proparse;

import com.joanju.proparse.IntegerIndex;
import com.joanju.proparse.NodeTypes;
import com.joanju.proparse.Preprocessor;
import com.joanju.proparse.ProParserTokenTypes;
import com.joanju.proparse.ProToken;
import com.joanju.proparse.StringFuncs;
import java.io.IOException;

public class Lexer
implements ProParserTokenTypes {
    private int currChar;
    private int currInt;
    private int currStringType;
    private StringBuilder currText = new StringBuilder();
    private IntegerIndex<String> filenameList;
    private Preprocessor prepro;
    private boolean preserve = false;
    private int preserveFile;
    private int preserveLine;
    private int preserveCol;
    private int preserveSource;
    private int preserveChar;
    private int textStartFile;
    private int textStartLine;
    private int textStartCol;
    private int textStartSource;
    private static final int EOF_CHAR = -1;

    Lexer(Preprocessor prepro) throws IOException {
        this.prepro = prepro;
        this.filenameList = prepro.doParse.getFilenameList();
        this.getChar();
    }

    ProToken nextToken() throws IOException {
        if (this.preserve) {
            this.textStartFile = this.preserveFile;
            this.textStartLine = this.preserveLine;
            this.textStartCol = this.preserveCol;
            this.textStartSource = this.preserveSource;
            this.currText.setLength(1);
            this.currText.setCharAt(0, (char)this.preserveChar);
            this.preserveDrop();
            switch (this.preserveChar) {
                case 46: {
                    return this.periodStart();
                }
                case 58: {
                    return this.colon();
                }
            }
        }
        if (this.currInt == -101) {
            this.textStartFile = this.prepro.textStartFile;
            this.textStartLine = this.prepro.textStartLine;
            this.textStartCol = this.prepro.textStartCol;
            this.textStartSource = this.prepro.textStartSourceNum;
            this.getChar();
            return this.makeToken(10, this.prepro.proparseDirectiveText);
        }
        this.textStartFile = this.prepro.getFileIndex();
        this.textStartLine = this.prepro.getLine();
        this.textStartCol = this.prepro.getColumn();
        this.textStartSource = this.prepro.getSourceNum();
        this.currText.setLength(1);
        this.currText.setCharAt(0, (char)this.currInt);
        switch (this.currChar) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                this.getChar();
                return this.whitespace();
            }
            case 34: 
            case 39: {
                if (this.prepro.escapeCurrent) {
                    this.getChar();
                    return this.id(269);
                }
                this.currStringType = this.currInt;
                this.getChar();
                return this.quotedString();
            }
            case 47: {
                this.getChar();
                if (this.currChar == 42) {
                    return this.comment();
                }
                if (this.currChar == 40 || this.currIsSpace()) {
                    return this.makeToken(900);
                }
                this.append();
                this.getChar();
                return this.id(269);
            }
            case 58: {
                this.getChar();
                return this.colon();
            }
            case 38: {
                this.getChar();
                return this.ampText();
            }
            case 64: {
                this.getChar();
                if (this.currIsSpace()) {
                    return this.makeToken(885);
                }
                this.append();
                this.getChar();
                return this.id(1130);
            }
            case 91: {
                this.getChar();
                return this.makeToken(886);
            }
            case 93: {
                this.getChar();
                return this.makeToken(887);
            }
            case 94: {
                this.getChar();
                return this.makeToken(888);
            }
            case 44: {
                this.getChar();
                return this.makeToken(889);
            }
            case 33: {
                this.getChar();
                return this.makeToken(890);
            }
            case 61: {
                this.getChar();
                return this.makeToken(894);
            }
            case 40: {
                this.getChar();
                return this.makeToken(897);
            }
            case 41: {
                this.getChar();
                return this.makeToken(898);
            }
            case 59: {
                this.getChar();
                return this.makeToken(899);
            }
            case 42: {
                this.getChar();
                return this.makeToken(901);
            }
            case 63: {
                this.getChar();
                return this.makeToken(903);
            }
            case 96: {
                this.getChar();
                return this.makeToken(905);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.getChar();
                return this.digitStart();
            }
            case 46: {
                this.getChar();
                return this.periodStart();
            }
            case 62: {
                this.getChar();
                if (this.currChar == 61) {
                    this.append();
                    this.getChar();
                    return this.makeToken(891);
                }
                return this.makeToken(884);
            }
            case 60: {
                this.getChar();
                if (this.currChar == 62) {
                    this.append();
                    this.getChar();
                    return this.makeToken(892);
                }
                if (this.currChar == 61) {
                    this.append();
                    this.getChar();
                    return this.makeToken(893);
                }
                return this.makeToken(883);
            }
            case 43: {
                this.getChar();
                return this.plusMinusStart(896);
            }
            case 45: {
                this.getChar();
                return this.plusMinusStart(895);
            }
            case 35: 
            case 37: 
            case 124: {
                this.getChar();
                return this.id(269);
            }
        }
        if (this.currInt == -1) {
            this.getChar();
            return this.makeToken(1, "");
        }
        this.getChar();
        return this.id(913);
    }

    ProToken colon() throws IOException {
        if (this.currChar == 58) {
            this.append();
            this.getChar();
            return this.makeToken(1131);
        }
        if (this.currIsSpace()) {
            return this.makeToken(917);
        }
        return this.makeToken(7);
    }

    ProToken whitespace() throws IOException {
        block3: while (true) {
            switch (this.currChar) {
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    this.append();
                    this.getChar();
                    continue block3;
                }
            }
            break;
        }
        return this.makeToken(906);
    }

    ProToken comment() throws IOException {
        this.prepro.doingComment = true;
        this.append();
        int commentLevel = 1;
        while (commentLevel > 0) {
            this.getChar();
            this.unEscapedAppend();
            if (this.currChar == 47) {
                this.getChar();
                this.unEscapedAppend();
                if (this.currChar != 42) continue;
                ++commentLevel;
                continue;
            }
            if (this.currChar == 42) {
                while (this.currChar == 42) {
                    this.getChar();
                    this.unEscapedAppend();
                    if (this.currChar != 47) continue;
                    --commentLevel;
                }
                continue;
            }
            if (this.currInt != -1) continue;
            this.prepro.lexicalThrow("Missing end of comment");
        }
        this.prepro.doingComment = false;
        this.getChar();
        return this.makeToken(907);
    }

    ProToken quotedString() throws IOException {
        while (true) {
            if (this.currInt == -1) {
                this.prepro.lexicalThrow("Unmatched quote");
            }
            this.unEscapedAppend();
            if (this.currInt == this.currStringType && !this.prepro.escapeCurrent) {
                this.getChar();
                if (this.currInt != this.currStringType) break;
                this.unEscapedAppend();
            }
            this.getChar();
        }
        if (this.currChar == 58) {
            boolean isStringAttributes = false;
            this.preserveCurrent();
            String theText = ":";
            block4: while (true) {
                this.getChar();
                switch (this.currChar) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 99: 
                    case 108: 
                    case 114: 
                    case 116: 
                    case 117: 
                    case 120: {
                        theText = String.valueOf(theText) + (char)this.currInt;
                        isStringAttributes = true;
                        continue block4;
                    }
                }
                break;
            }
            if (isStringAttributes) {
                this.append(theText);
                this.preserveDrop();
            }
        }
        return this.makeToken(8);
    }

    ProToken digitStart() throws IOException {
        int ttype = 6;
        block8: while (true) {
            switch (this.currChar) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.append();
                    this.getChar();
                    continue block8;
                }
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.append();
                    this.getChar();
                    if (ttype == 269) continue block8;
                    ttype = 913;
                    continue block8;
                }
                case 43: 
                case 45: {
                    this.append();
                    this.getChar();
                    continue block8;
                }
                case 47: {
                    this.append();
                    this.getChar();
                    if (ttype != 6) continue block8;
                    ttype = 4;
                    continue block8;
                }
                case 92: {
                    this.append();
                    this.getChar();
                    ttype = 269;
                    continue block8;
                }
                case 46: {
                    if (!this.prepro.nameDot) break block8;
                    this.append();
                    this.getChar();
                    continue block8;
                }
            }
            break;
        }
        return this.makeToken(ttype);
    }

    ProToken plusMinusStart(int inputType) throws IOException {
        int ttype = 6;
        block5: while (true) {
            switch (this.currChar) {
                case 43: 
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.append();
                    this.getChar();
                    continue block5;
                }
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 47: 
                case 92: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.append();
                    this.getChar();
                    ttype = 269;
                    continue block5;
                }
                case 46: {
                    if (!this.prepro.nameDot) break block5;
                    this.append();
                    this.getChar();
                    continue block5;
                }
            }
            break;
        }
        if (this.currText.length() == 1) {
            return this.makeToken(inputType);
        }
        return this.makeToken(ttype);
    }

    ProToken periodStart() throws IOException {
        if (!Character.isDigit(this.currChar)) {
            if (this.prepro.nameDot) {
                return this.makeToken(5);
            }
            return this.makeToken(9);
        }
        int ttype = 6;
        block4: while (true) {
            switch (this.currChar) {
                case 43: 
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.append();
                    this.getChar();
                    continue block4;
                }
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 47: 
                case 92: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.append();
                    this.getChar();
                    ttype = 269;
                    continue block4;
                }
            }
            break;
        }
        return this.makeToken(ttype);
    }

    ProToken id(int inputTokenType) throws IOException {
        int ttype = inputTokenType;
        block4: while (true) {
            switch (this.currChar) {
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 45: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 59: 
                case 64: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.append();
                    this.getChar();
                    continue block4;
                }
                case 39: 
                case 92: {
                    this.append();
                    this.getChar();
                    if (ttype != 913) continue block4;
                    ttype = 269;
                    continue block4;
                }
            }
            if (this.currInt < 128 || this.currInt > 255) break;
            this.append();
            this.getChar();
        }
        if (ttype == 913) {
            ttype = NodeTypes.testLiteralsTable(this.currText.toString(), ttype);
        }
        return this.makeToken(ttype);
    }

    ProToken ampText() throws IOException {
        ProToken t;
        block3: while (true) {
            if (Character.isLetterOrDigit(this.currInt) || this.currInt >= 128 && this.currInt <= 255) {
                this.append();
                this.getChar();
                continue;
            }
            switch (this.currChar) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 45: 
                case 95: {
                    this.append();
                    this.getChar();
                    continue block3;
                }
            }
            if (this.currChar != 47) break;
            this.preserveCurrent();
            this.getChar();
            if (this.currChar != 42) break;
            String s = this.currText.toString();
            this.comment();
            this.currText.replace(0, this.currText.length(), s);
            this.preserveDrop();
        }
        if ((t = this.directive()) != null) {
            return t;
        }
        return this.makeToken(269);
    }

    ProToken directive() throws IOException {
        String macroType = this.currText.toString().toLowerCase();
        if ("&global-define".startsWith(macroType) && macroType.length() >= 4) {
            this.appendToEOL();
            this.macroDefine(935);
            this.getChar();
            return this.makeToken(935);
        }
        if ("&scoped-define".startsWith(macroType) && macroType.length() >= 4) {
            this.appendToEOL();
            this.macroDefine(943);
            this.getChar();
            return this.makeToken(943);
        }
        if ("&undefine".startsWith(macroType) && macroType.length() >= 5) {
            while (Character.isWhitespace(this.currChar)) {
                this.append();
                this.getChar();
            }
            while (!Character.isWhitespace(this.currChar) && this.currInt != -1) {
                this.append();
                this.getChar();
            }
            if (this.currChar == 13) {
                this.append();
                this.getChar();
                if (this.currChar == 10) {
                    this.append();
                    this.getChar();
                }
            } else if (this.currInt != -1) {
                this.append();
                this.getChar();
            }
            this.macroUndefine();
            return this.makeToken(942);
        }
        if (macroType.equals("&analyze-suspend")) {
            this.appendToEOL();
            this.getChar();
            return this.makeToken(933);
        }
        if (macroType.equals("&analyze-resume")) {
            this.appendToEOL();
            this.getChar();
            return this.makeToken(934);
        }
        if (macroType.equals("&message")) {
            this.appendToEOL();
            this.getChar();
            return this.makeToken(940);
        }
        if (macroType.equals("&if")) {
            return this.makeToken(939);
        }
        if (macroType.equals("&then")) {
            return this.makeToken(941);
        }
        if (macroType.equals("&elseif")) {
            return this.makeToken(937);
        }
        if (macroType.equals("&else")) {
            return this.makeToken(936);
        }
        if (macroType.equals("&endif")) {
            return this.makeToken(938);
        }
        return null;
    }

    void append() {
        this.currText.append((char)this.currInt);
    }

    void append(char c) {
        this.currText.append(c);
    }

    void append(String theText) {
        this.currText.append(theText);
    }

    void appendToEOL() throws IOException {
        while (true) {
            if (this.currChar == 47) {
                this.append();
                this.getChar();
                if (this.currChar != 42) continue;
                this.comment();
                continue;
            }
            if (this.currInt == -1) break;
            this.append();
            if (this.currChar == 10) break;
            this.getChar();
        }
    }

    boolean currIsSpace() {
        return this.currInt == -1 || Character.isWhitespace(this.currChar);
    }

    void getChar() throws IOException {
        this.currInt = this.prepro.getChar();
        this.currChar = Character.toLowerCase(this.currInt);
    }

    void macroDefine(int defType) throws IOException {
        if (this.prepro.consuming != 0) {
            return;
        }
        int it = 0;
        int end = this.currText.length();
        while (!Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        while (Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        int start = it;
        while (!Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        String macroName = this.currText.substring(start, it);
        while (it != end && Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        String defText = StringFuncs.stripComments(this.currText.substring(it));
        defText = defText.trim();
        if (this.prepro.listing) {
            StringBuilder bldr = new StringBuilder();
            bldr.append(this.textStartFile).append(" ").append(this.textStartLine).append(" ").append(this.textStartCol).append(defType == 935 ? " globdef " : " scopdef ").append(macroName).append(" ").append(StringFuncs.escapeLineBreaks(defText));
            this.prepro.listingStream.write(bldr.toString());
            this.prepro.listingStream.newLine();
        }
        if (defType == 935) {
            this.prepro.defGlobal(macroName.toLowerCase(), defText);
        } else {
            this.prepro.defScoped(macroName.toLowerCase(), defText);
        }
    }

    void macroUndefine() throws IOException {
        if (this.prepro.consuming != 0) {
            return;
        }
        int it = 0;
        int end = this.currText.length();
        while (!Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        while (Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        int start = it;
        while (it != end && !Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        String macroName = this.currText.substring(start, it);
        if (this.prepro.listing) {
            StringBuilder bldr = new StringBuilder();
            bldr.append(this.textStartFile).append(" ").append(this.textStartLine).append(" ").append(this.textStartCol).append(" undef ").append(macroName);
            this.prepro.listingStream.write(bldr.toString());
            this.prepro.listingStream.newLine();
        }
        this.prepro.undef(macroName.toLowerCase());
    }

    ProToken makeToken(int ttype) {
        return new ProToken(this.filenameList, ttype, this.currText.toString(), this.textStartFile, this.textStartLine, this.textStartCol, this.textStartSource);
    }

    ProToken makeToken(int ttype, String text) {
        return new ProToken(this.filenameList, ttype, text, this.textStartFile, this.textStartLine, this.textStartCol, this.textStartSource);
    }

    ProToken makeToken(int ttype, char text) {
        return new ProToken(this.filenameList, ttype, Character.toString(text), this.textStartFile, this.textStartLine, this.textStartCol, this.textStartSource);
    }

    void preserveCurrent() {
        this.preserve = true;
        this.preserveFile = this.prepro.getFileIndex();
        this.preserveLine = this.prepro.getLine();
        this.preserveCol = this.prepro.getColumn();
        this.preserveSource = this.prepro.getSourceNum();
        this.preserveChar = this.currChar;
    }

    void preserveDrop() {
        this.preserve = false;
    }

    void unEscapedAppend() {
        if (this.prepro.wasEscape) {
            this.append(this.prepro.escapeText);
            if (this.prepro.escapeAppend) {
                this.append();
            }
        } else {
            this.append();
        }
    }
}

