/*
 * Decompiled with CFR 0.152.
 */
package com.joanju.proparse;

import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamException;
import com.joanju.proparse.ClassFinder;
import com.joanju.proparse.DoParse;
import com.joanju.proparse.Environment;
import com.joanju.proparse.ProToken;
import com.joanju.proparse.SymbolScope;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.prorefactor.core.JPNode;

public class ParserSupport {
    private JPNode topNode;
    private boolean currDefInheritable = false;
    private boolean unitIsInterface = false;
    private ClassFinder classFinder = new ClassFinder();
    private DoParse doParse;
    private Environment environment = Environment.instance();
    private HashMap<String, SymbolScope> funcScopeMap = new HashMap();
    private String thisClassName = "";
    private SymbolScope inheritanceScope;
    private SymbolScope currentScope = this.unitScope = new SymbolScope();
    private SymbolScope unitScope;
    private JPNode lastFieldRefNode;
    private JPNode lastFieldIDNode;

    ParserSupport(DoParse doParse) {
        this.doParse = doParse;
    }

    int abbrevDatatype(String text) {
        String s = text.toLowerCase();
        if ("cha".startsWith(s)) {
            return 103;
        }
        if (s.equals("da") || s.equals("dat")) {
            return 166;
        }
        if (s.equals("de")) {
            return 183;
        }
        if (s.equals("i") || s.equals("in")) {
            return 385;
        }
        if ("logical".startsWith(s)) {
            return 439;
        }
        if (s.equals("rec") || s.equals("reci")) {
            return 643;
        }
        if (s.equals("rowi")) {
            return 679;
        }
        if ("widget-h".startsWith(s) && s.length() >= 4) {
            return 856;
        }
        return 0;
    }

    void addInnerScope() {
        this.currentScope = new SymbolScope(this.currentScope);
    }

    static void attrOp(JPNode ast) {
        ast.attrSet(1200, 1);
    }

    void declareMethod(String s) {
        this.unitScope.defMethod(s);
    }

    void defBuffer(String bufferName, String tableName) {
        this.currentScope.defBuffer(bufferName, tableName);
        if (this.currDefInheritable) {
            this.inheritanceScope.defBuffer(bufferName, tableName);
        }
    }

    void defClass(JPNode classNode) {
        try {
            JPNode idNode = classNode.firstChild();
            this.thisClassName = ClassFinder.dequote(idNode.getText());
            this.inheritanceScope = new SymbolScope();
            this.environment.addToSuperCache(this.thisClassName, this.inheritanceScope);
            this.inheritanceScope.setScopeName(this.thisClassName);
            JPNode nextNode = idNode.nextSibling();
            if (nextNode != null && nextNode.getType() == 1110) {
                String inheritName = nextNode.firstChild().attrGetS(2400);
                SymbolScope scope = this.environment.lookupSuper(inheritName);
                if (scope == null) {
                    scope = this.parseSuper(classNode, inheritName);
                }
                if (scope != null) {
                    this.unitScope.setSuperScope(scope);
                    this.inheritanceScope.setSuperScope(scope);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void defMethod(JPNode idNode) {
        String methodName = idNode.getText();
        this.unitScope.defMethod(methodName);
        if (this.currDefInheritable) {
            this.inheritanceScope.defMethod(methodName);
        }
    }

    void defTable(String name, SymbolScope.FieldType ttype) {
        this.currentScope.defTable(name, ttype);
        if (this.currDefInheritable) {
            this.inheritanceScope.defTable(name, ttype);
        }
    }

    void defVar(String name) {
        this.currentScope.defVar(name);
        if (this.currDefInheritable) {
            this.inheritanceScope.defVar(name);
        }
    }

    void defVarInline() {
        this.currentScope.defVar(this.lastFieldIDNode.getText());
        if (this.currDefInheritable) {
            this.inheritanceScope.defVar(this.lastFieldIDNode.getText());
        }
        this.lastFieldRefNode.attrSet(2000, 1);
    }

    void dropInnerScope() {
        assert (this.currentScope != this.unitScope);
        this.currentScope = this.currentScope.getSuperScope();
    }

    void fieldReference(JPNode refNode, JPNode idNode) {
        this.lastFieldRefNode = refNode;
        this.lastFieldIDNode = idNode;
    }

    void filenameMerge(JPNode node) {
        JPNode currNode = node;
        JPNode nextNode = node.nextSibling();
        while (nextNode != null) {
            if (currNode.getType() == 269 && nextNode.getType() == 269 && nextNode.getHiddenBefore() == null) {
                currNode.setHiddenAfter(nextNode.getHiddenAfter());
                currNode.setText(String.valueOf(currNode.getText()) + nextNode.getText());
                currNode.setNextSibling(nextNode.nextSibling());
                nextNode = currNode.nextSibling();
                continue;
            }
            currNode = currNode.nextSibling();
            nextNode = currNode.nextSibling();
        }
    }

    void funcBegin(JPNode idNode) {
        String lowername = idNode.getText().toLowerCase();
        SymbolScope ss = this.funcScopeMap.get(lowername);
        if (ss != null) {
            this.currentScope = ss;
        } else {
            SymbolScope newScope;
            this.currentScope = newScope = new SymbolScope(this.currentScope);
            this.funcScopeMap.put(lowername, newScope);
            this.unitScope.defFunc(lowername);
        }
    }

    void funcEnd() {
        this.currentScope = this.currentScope.getSuperScope();
    }

    static boolean hasHiddenAfter(Token token) {
        return ((ProToken)token).getHiddenAfter() != null;
    }

    static boolean hasHiddenBefore(Token token) {
        return ((ProToken)token).getHiddenBefore() != null;
    }

    void interfaceNode(JPNode interfaceNode) {
        this.unitIsInterface = true;
        this.thisClassName = ClassFinder.dequote(interfaceNode.firstChild().getText());
    }

    boolean isClass() {
        return this.inheritanceScope != null;
    }

    boolean isInterface() {
        return this.unitIsInterface;
    }

    SymbolScope.FieldType isTable(String inName) {
        return this.currentScope.isTable(inName);
    }

    SymbolScope.FieldType isTableSchemaFirst(String inName) {
        return this.currentScope.isTableSchemaFirst(inName);
    }

    boolean isTableName(Token lt1, Token lt2, Token lt3, Token lt4) {
        String name = lt1.getText();
        if (lt2.getType() == 5) {
            if (lt4.getType() == 5) {
                return false;
            }
            name = String.valueOf(name) + "." + lt3.getText();
        }
        if (this.isVar(name)) {
            return false;
        }
        return this.isTable(name.toLowerCase()) != null;
    }

    boolean isVar(String name) {
        return this.currentScope.isVar(name);
    }

    int methodOrFunc(String name) {
        return this.unitScope.methodOrFunc(name);
    }

    SymbolScope parseSuper(JPNode classNode, String qualSuperName) throws IOException, TokenStreamException, RecognitionException {
        String superFileName = this.classFinder.findClassFile(qualSuperName);
        if (superFileName.length() == 0) {
            return null;
        }
        BufferedReader ifstream = new BufferedReader(new FileReader(superFileName));
        DoParse superDoParse = new DoParse(superFileName, this.doParse);
        superDoParse.inStream = ifstream;
        superDoParse.doParse();
        ParserSupport superSupport = superDoParse.getParserSupport();
        if (!superSupport.isClass()) {
            throw new RuntimeException(String.valueOf(this.unitScope.getScopeName()) + " inherits " + qualSuperName + " which is not a class.");
        }
        SymbolScope superScope = this.environment.lookupSuper(qualSuperName);
        if (superScope == null) {
            throw new RuntimeException("Internal error. parseSuper failed to find superScope.");
        }
        SymbolScope p = superScope.getSuperScope();
        while (p != null) {
            if (p == superScope) {
                throw new RuntimeException("Circular inheritance found from class: " + qualSuperName);
            }
            p = p.getSuperScope();
        }
        classNode.setLink(-219, superSupport.topNode);
        return superScope;
    }

    void setCurrDefInheritable(boolean canInherit) {
        this.currDefInheritable = canInherit && this.inheritanceScope != null && this.currentScope == this.unitScope;
    }

    void setStoreType(JPNode node, SymbolScope.FieldType tabletype) {
        switch (tabletype) {
            case DBTABLE: {
                node.attrSet(1100, 1102);
                break;
            }
            case TTABLE: {
                node.attrSet(1100, 1103);
                break;
            }
            case WTABLE: {
                node.attrSet(1100, 1104);
            }
        }
    }

    void setTopNode(JPNode refTopNode) {
        this.topNode = refTopNode;
    }

    void typenameLookup(JPNode typenameNode) {
        typenameNode.attrSet(2400, this.classFinder.lookup(typenameNode.getText()));
    }

    void typenameThis(JPNode typenameNode) {
        typenameNode.attrSet(2400, this.thisClassName);
    }

    void usingState(JPNode typeNameNode) {
        this.classFinder.addPath(typeNameNode.getText());
    }
}

