/*
 * Decompiled with CFR 0.152.
 */
package com.joanju.proparse;

import com.joanju.proparse.DoParse;
import com.joanju.proparse.Environment;
import com.joanju.proparse.IncludeFile;
import com.joanju.proparse.InputSource;
import com.joanju.proparse.StringFuncs;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocessor {
    int consuming = 0;
    int currChar;
    int currCol;
    int currFile;
    int currLine;
    int currSourceNum;
    boolean doingComment = false;
    boolean escapeAppend;
    boolean escapeCurrent = false;
    String escapeText;
    DoParse doParse;
    boolean listing = false;
    BufferedWriter listingStream;
    boolean nameDot;
    boolean printTrace = false;
    String proparseDirectiveText;
    int textStartFile;
    int textStartLine;
    int textStartCol;
    int textStartSourceNum;
    boolean wasEscape;
    private IncludeFile currentInclude;
    private InputSource currentInput;
    private Environment env = Environment.instance();
    private HashMap<String, String> globalDefdNames = new HashMap();
    private boolean gotLookahead = false;
    private LinkedList<IncludeFile> includeVector = new LinkedList();
    private int laFile;
    private int laLine;
    private int laCol;
    private int laSourceNum;
    private int laChar;
    private int safetyNet = 0;
    private int sequence = 0;
    private int sourceCounter;
    static final int EOF_CHAR = -1;
    static final int SKIP_CHAR = -100;
    public static final int PROPARSE_DIRECTIVE = -101;
    private static final Pattern regexNumberedArg = Pattern.compile("\\{\\d+\\}");
    private static final Pattern regexEmptyCurlies = Pattern.compile("\\{\\s*\\}");

    public Preprocessor(String fileName, BufferedReader inStream, DoParse doParse) {
        this.doParse = doParse;
        this.sourceCounter = -1;
        this.currFile = doParse.addFilename(fileName);
        this.currentInput = new InputSource(++this.sourceCounter, inStream, true);
        this.currentInput.fileIndex = this.currFile;
        this.currentInclude = new IncludeFile(fileName, this.currentInput);
        this.includeVector.add(this.currentInclude);
        this.currSourceNum = this.currentInput.sourceNum;
    }

    private void checkForNameDot() throws IOException {
        if (!this.gotLookahead) {
            this.laGet();
        }
        this.nameDot = this.laChar != -1 && !Character.isWhitespace(this.laChar);
    }

    String defined(String argName) {
        if (this.currentInclude.defdNames.containsKey(argName)) {
            return "3";
        }
        if (this.currentInclude.getNamedArg(argName) != null) {
            return "2";
        }
        for (IncludeFile incl : this.includeVector) {
            if (!incl.defdNames.containsKey(argName)) continue;
            return "3";
        }
        if (this.globalDefdNames.containsKey(argName)) {
            return "1";
        }
        return "0";
    }

    void defGlobal(String argName, String argVal) {
        this.globalDefdNames.put(argName, argVal);
    }

    void defScoped(String argName, String argVal) {
        this.currentInclude.defdNames.put(argName, argVal);
    }

    private int escape() throws IOException {
        if (this.wasEscape) {
            this.escapeText = String.valueOf(this.escapeText) + (char)this.currChar;
        } else {
            this.wasEscape = true;
            this.escapeText = Character.toString((char)this.currChar);
            this.escapeAppend = true;
        }
        this.getRawChar();
        int retChar = this.currChar;
        this.escapeCurrent = true;
        switch (this.currChar) {
            case 10: {
                this.escapeText = String.valueOf(this.escapeText) + (char)this.currChar;
                retChar = -100;
                break;
            }
            case 13: {
                if (!this.gotLookahead) {
                    this.laGet();
                }
                if (this.laChar == 10) {
                    this.escapeText = String.valueOf(this.escapeText) + "\r\n";
                    this.laUse();
                    retChar = -100;
                    break;
                }
                retChar = 13;
                break;
            }
            case 114: {
                this.escapeText = String.valueOf(this.escapeText) + (char)this.currChar;
                this.escapeAppend = false;
                retChar = 13;
                break;
            }
            case 110: {
                this.escapeText = String.valueOf(this.escapeText) + (char)this.currChar;
                this.escapeAppend = false;
                retChar = 10;
                break;
            }
            default: {
                this.escapeAppend = true;
            }
        }
        return retChar;
    }

    String getArgText(int argNum) {
        if (argNum >= this.currentInclude.numdArgs.size()) {
            return "";
        }
        return this.currentInclude.numdArgs.get(argNum);
    }

    String getArgText(String argName) {
        String ret = this.currentInclude.defdNames.get(argName);
        if (ret != null) {
            return ret;
        }
        ret = this.currentInclude.getNamedArg(argName);
        if (ret != null) {
            return ret;
        }
        int i = this.includeVector.size() - 1;
        while (i >= 0) {
            ret = this.includeVector.get((int)i).defdNames.get(argName);
            if (ret != null) {
                return ret;
            }
            --i;
        }
        ret = this.globalDefdNames.get(argName);
        if (ret != null) {
            return ret;
        }
        if (argName.equals("*")) {
            StringBuilder allArgs = new StringBuilder();
            int i1 = 1;
            while (i1 < this.currentInclude.numdArgs.size()) {
                if (i1 > 1) {
                    allArgs.append(" ");
                }
                allArgs.append(this.currentInclude.numdArgs.get(i1));
                ++i1;
            }
            return allArgs.toString();
        }
        if (argName.equals("&*")) {
            return this.currentInclude.getAllNamedArgs();
        }
        if (argName.equals("batch-mode")) {
            return this.env.batchMode;
        }
        if (argName.equals("opsys")) {
            return this.env.opsys;
        }
        if (argName.equals("window-system")) {
            return this.env.windowSystem;
        }
        if (argName.equals("file-name")) {
            ret = this.env.findFile(this.currentInclude.numdArgs.get(0));
            ret = this.env.opsysNum == 2 ? ret.replace('\\', '/') : ret.replace('/', '\\');
            return ret;
        }
        if (argName.equals("line-number")) {
            return Integer.toString(this.getLine());
        }
        if (argName.equals("sequence")) {
            return Integer.toString(this.sequence++);
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getChar() throws IOException {
        this.wasEscape = false;
        block5: while (true) {
            this.escapeCurrent = false;
            if (this.gotLookahead) {
                this.laUse();
            } else {
                this.getRawChar();
            }
            switch (this.currChar) {
                case 92: 
                case 126: {
                    if (this.currChar == 92 && this.env.opsysNum != 2) {
                        return this.currChar;
                    }
                    int retChar = this.escape();
                    if (retChar == 46) {
                        this.checkForNameDot();
                    }
                    if (retChar == -100) continue block5;
                    return retChar;
                }
                case 123: {
                    if (this.doingComment) {
                        return this.currChar;
                    }
                    this.macroReference();
                    if (this.currChar == -101) return this.currChar;
                    continue block5;
                }
                case 46: {
                    this.checkForNameDot();
                    return this.currChar;
                }
            }
            break;
        }
        return this.currChar;
    }

    int getColumn() {
        return this.currCol;
    }

    int getFileIndex() {
        return this.currFile;
    }

    String getFilename() {
        return this.doParse.getFilename(this.currentInput.fileIndex);
    }

    String getFilename(int fileIndex) {
        return this.doParse.getFilename(fileIndex);
    }

    int getLine() {
        return this.currLine;
    }

    /*
     * Unable to fully structure code
     */
    private void getRawChar() throws IOException {
        this.currLine = this.currentInput.nextLine;
        this.currCol = this.currentInput.nextCol;
        this.currChar = this.currentInput.get();
        if (this.currChar != 65533) ** GOTO lbl28
        throw new RuntimeException("Character conversion error.\nCould not read character from source file\n" + this.getFilename() + " line " + this.currLine + " column " + this.currCol + "\nThis indicates a character that cannot be converted to Unicode using" + "\nthe current file I/O code page: " + System.getProperty("file.encoding") + "\nTry using a different encoding from the Java Virtual Machine command line" + "\nfor example: -Dfile.encoding=\"ISO8859_1\"");
lbl-1000:
        // 1 sources

        {
            switch (this.popInput()) {
                case 0: {
                    ++this.safetyNet;
                    if (this.safetyNet > 100) {
                        throw new RuntimeException("Proparse error. Infinite loop caught by preprocessor.");
                    }
                    return;
                }
                case 1: {
                    this.currFile = this.currentInput.fileIndex;
                    this.currLine = this.currentInput.nextLine;
                    this.currCol = this.currentInput.nextCol;
                    this.currSourceNum = this.currentInput.sourceNum;
                    this.currChar = 32;
                    return;
                }
                case 2: {
                    this.currFile = this.currentInput.fileIndex;
                    this.currLine = this.currentInput.nextLine;
                    this.currCol = this.currentInput.nextCol;
                    this.currChar = this.currentInput.get();
                    this.currSourceNum = this.currentInput.sourceNum;
                    break;
                }
                default: {
                    throw new RuntimeException("Proparse error. popInput() returned unexpected value.");
                }
            }
lbl28:
            // 2 sources

            ** while (this.currChar == -1)
        }
lbl29:
        // 1 sources

    }

    int getSourceNum() {
        return this.currSourceNum;
    }

    private String includeRefArg(CharPos cp) {
        boolean gobbleWS = false;
        StringBuilder theRet = new StringBuilder();
        while (cp.pos < cp.chars.length - 1) {
            char c = cp.chars[cp.pos];
            switch (c) {
                case '\"': {
                    if (cp.chars[cp.pos + 1] == '\"') {
                        theRet.append('\"');
                        ++cp.pos;
                        ++cp.pos;
                        break;
                    }
                    gobbleWS = !gobbleWS;
                    ++cp.pos;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (gobbleWS) {
                        theRet.append(c);
                        ++cp.pos;
                        break;
                    }
                    return theRet.toString();
                }
                default: {
                    theRet.append(c);
                    ++cp.pos;
                }
            }
        }
        return theRet.toString();
    }

    void initListing() throws IOException {
        String listingFile = this.env.configGet("listing-file");
        if (listingFile == null || listingFile.length() == 0) {
            return;
        }
        this.listing = true;
        this.listingStream = new BufferedWriter(new FileWriter(listingFile));
    }

    private void laGet() throws IOException {
        int saveFile = this.currFile;
        int saveLine = this.currLine;
        int saveCol = this.currCol;
        int saveSourceNum = this.currSourceNum;
        int saveChar = this.currChar;
        this.getRawChar();
        this.gotLookahead = true;
        this.laFile = this.currFile;
        this.laLine = this.currLine;
        this.laCol = this.currCol;
        this.laChar = this.currChar;
        this.laSourceNum = this.currSourceNum;
        this.currFile = saveFile;
        this.currLine = saveLine;
        this.currCol = saveCol;
        this.currSourceNum = saveSourceNum;
        this.currChar = saveChar;
    }

    private void laUse() {
        this.gotLookahead = false;
        this.currFile = this.laFile;
        this.currLine = this.laLine;
        this.currCol = this.laCol;
        this.currSourceNum = this.laSourceNum;
        this.currChar = this.laChar;
    }

    void lexicalThrow(String theMessage) {
        throw new IllegalArgumentException(String.valueOf(this.getFilename()) + ":" + Integer.toString(this.getLine()) + " " + theMessage);
    }

    /*
     * Unable to fully structure code
     */
    private void macroReference() throws IOException {
        block28: {
            block29: {
                this.textStartFile = this.currFile;
                this.textStartLine = this.currLine;
                this.textStartCol = this.currCol;
                this.textStartSourceNum = this.currSourceNum;
                incArgs = new ArrayList<IncludeArg>();
                refPos = new FilePos(this.textStartFile, this.textStartLine, this.textStartCol, this.textStartSourceNum);
                refTextBldr = new StringBuilder("{");
                macroChar = (char)this.getChar();
                while ((macroChar != '}' || this.wasEscape) && macroChar != '\uffffffff') {
                    refTextBldr.append(macroChar);
                    macroChar = (char)this.getChar();
                }
                if (macroChar == '\uffffffff') {
                    this.lexicalThrow("Unmatched curly brace");
                }
                refTextBldr.append(macroChar);
                refText = refTextBldr.toString();
                cp = new CharPos(refText.toCharArray(), 0);
                refTextEnd = refText.length();
                closingCurly = refTextEnd - 1;
                if (refText.toLowerCase().startsWith("{&_proparse_") && this.env.proparseDirectives) {
                    this.currChar = -101;
                    this.proparseDirectiveText = refText.substring(12, closingCurly).trim();
                    ++this.sourceCounter;
                    if (this.listing) {
                        bldr = new StringBuilder();
                        bldr.append(refPos.file).append(" ").append(refPos.line).append(" ").append(refPos.col).append(" macroref _proparse_");
                        this.listingStream.write(bldr.toString());
                        this.listingStream.newLine();
                        this.listingStream.write("0 0 0 macrorefend");
                        this.listingStream.newLine();
                    }
                    return;
                }
                if (refText.equals("{*}")) {
                    this.newMacroRef("*", refPos);
                    return;
                }
                if (refText.startsWith("{&*")) {
                    this.newMacroRef("&*", refPos);
                    return;
                }
                if (Preprocessor.regexNumberedArg.matcher(refText).matches()) {
                    theText = refText.substring(1, closingCurly);
                    argNum = Integer.parseInt(theText);
                    this.newMacroRef(argNum, refPos);
                    return;
                }
                if (Preprocessor.regexEmptyCurlies.matcher(refText).matches()) {
                    return;
                }
                if (refText.startsWith("{&")) {
                    argName = refText.substring(2, closingCurly).trim().toLowerCase();
                    this.newMacroRef(argName, refPos);
                    return;
                }
                usingNamed = false;
                cp.pos = 1;
                while (Character.isWhitespace(cp.chars[cp.pos])) {
                    ++cp.pos;
                }
                includeFilename = this.includeRefArg(cp);
                while (Character.isWhitespace(cp.chars[cp.pos])) {
                    ++cp.pos;
                }
                if (cp.pos == closingCurly) break block28;
                if (cp.chars[cp.pos] != '&') break block29;
                usingNamed = true;
                while (cp.pos != refTextEnd && cp.chars[cp.pos] == '&') {
                    ++cp.pos;
                    argName = "";
                    while (cp.pos != refTextEnd) {
                        if (cp.pos == closingCurly || cp.chars[cp.pos] == '=') break;
                        if (!Character.isWhitespace(cp.chars[cp.pos])) {
                            argName = String.valueOf(argName) + cp.chars[cp.pos];
                        }
                        ++cp.pos;
                    }
                    argVal = "";
                    if (cp.chars[cp.pos] == '=') {
                        ++cp.pos;
                        while (cp.pos != closingCurly && Character.isWhitespace(cp.chars[cp.pos])) {
                            ++cp.pos;
                        }
                        if (cp.pos != closingCurly) {
                            argVal = this.includeRefArg(cp);
                        }
                    }
                    incArgs.add(new IncludeArg(argName, argVal));
                    while (cp.pos != refTextEnd && cp.chars[cp.pos] != '&') {
                        ++cp.pos;
                    }
                }
                break block28;
            }
            usingNamed = false;
            ** GOTO lbl97
            {
                ++cp.pos;
                do {
                    if (Character.isWhitespace(cp.chars[cp.pos])) continue block7;
                    if (cp.pos == closingCurly) break block7;
                    incArgs.add(new IncludeArg("", this.includeRefArg(cp)));
lbl97:
                    // 2 sources

                } while (cp.pos != refTextEnd);
            }
        }
        if (this.newInclude(includeFilename)) {
            this.currFile = this.currentInput.fileIndex;
            this.currSourceNum = this.currentInput.sourceNum;
            if (this.listing) {
                bldr = new StringBuilder();
                bldr.append(refPos.file).append(" ").append(refPos.line).append(" ").append(refPos.col).append(" include ").append(this.currFile).append(" ").append(includeFilename);
                this.listingStream.write(bldr.toString());
                this.listingStream.newLine();
            }
            argNum = 1;
            for (IncludeArg incarg : incArgs) {
                if (usingNamed) {
                    this.currentInclude.defNamedArg(incarg.argName, incarg.argVal);
                } else {
                    this.currentInclude.numdArgs.add(incarg.argVal);
                }
                if (this.listing) {
                    this.listingStream.write("0 0 0 incarg ");
                    if (usingNamed) {
                        this.listingStream.write(incarg.argName);
                    } else {
                        this.listingStream.write(Integer.toString(argNum));
                    }
                    this.listingStream.write(" ");
                    this.listingStream.write(StringFuncs.escapeLineBreaks(incarg.argVal));
                    this.listingStream.newLine();
                }
                ++argNum;
            }
        }
    }

    boolean newInclude(String referencedWithName) throws IOException {
        String fName = referencedWithName.trim();
        if (this.consuming != 0 || fName.length() == 0) {
            return false;
        }
        if ((fName = this.env.findFile(fName)).equals("")) {
            throw new IOException(String.valueOf(this.getFilename()) + ": " + "Could not find include file: " + referencedWithName);
        }
        this.currentInput = new InputSource(++this.sourceCounter, new BufferedReader(new FileReader(fName)));
        this.currentInput.fileIndex = this.doParse.addFilename(fName);
        this.currentInclude = new IncludeFile(referencedWithName, this.currentInput);
        this.includeVector.add(this.currentInclude);
        if (this.printTrace) {
            System.out.println();
            System.out.println("** Entering file: " + this.getFilename());
        }
        return true;
    }

    void newMacroRef(String macroName, FilePos refPos) throws IOException {
        if (this.listing) {
            StringBuilder bldr = new StringBuilder();
            bldr.append(refPos.file).append(" ").append(refPos.line).append(" ").append(refPos.col).append(" macroref ").append(macroName);
            this.listingStream.write(bldr.toString());
            this.listingStream.newLine();
        }
        this.newMacroRef2(this.getArgText(macroName), refPos);
    }

    void newMacroRef(int argNum, FilePos refPos) throws IOException {
        if (this.listing) {
            StringBuilder bldr = new StringBuilder();
            bldr.append(refPos.file).append(" ").append(refPos.line).append(" ").append(refPos.col).append(" macroref ").append(argNum);
            this.listingStream.write(bldr.toString());
            this.listingStream.newLine();
        }
        this.newMacroRef2(this.getArgText(argNum), refPos);
    }

    void newMacroRef2(String theText, FilePos refPos) throws IOException {
        if (theText.length() == 0) {
            ++this.sourceCounter;
            if (this.listing) {
                this.listingStream.write("0 0 0 macrorefend");
                this.listingStream.newLine();
            }
            return;
        }
        this.currentInput = new InputSource(++this.sourceCounter, new BufferedReader(new StringReader(theText)));
        this.currentInclude.inputVector.add(this.currentInput);
        this.currentInput.isMacroExpansion = true;
        this.currentInput.fileIndex = refPos.file;
        this.currentInput.nextLine = refPos.line;
        this.currentInput.nextCol = refPos.col;
    }

    void parseComplete() throws IOException {
        while (this.popInput() != 0) {
        }
        if (this.listing) {
            this.listingStream.close();
        }
    }

    int popInput() throws IOException {
        if (this.currentInclude.inputVector.size() > 1) {
            this.currentInclude.inputVector.removeLast();
            this.currentInput = this.currentInclude.inputVector.getLast();
            if (this.listing) {
                this.listingStream.write("0 0 0 macrorefend");
                this.listingStream.newLine();
            }
            return 2;
        }
        if (this.includeVector.size() > 1) {
            this.includeVector.removeLast();
            this.currentInclude = this.includeVector.getLast();
            this.currentInput = this.currentInclude.inputVector.getLast();
            if (this.printTrace) {
                System.out.println();
                System.out.println("** Back to file: " + this.getFilename());
            }
            if (this.listing) {
                this.listingStream.write("0 0 0 incend");
                this.listingStream.newLine();
            }
            return 1;
        }
        return 0;
    }

    void undef(String argName) {
        if (this.undef_helper(argName, this.currentInclude.defdNames)) {
            return;
        }
        if (this.currentInclude.undefNamedArg(argName)) {
            return;
        }
        ListIterator<IncludeFile> it = this.includeVector.listIterator(this.includeVector.size());
        while (it.hasPrevious()) {
            IncludeFile incfile = it.previous();
            if (!this.undef_helper(argName, incfile.defdNames)) continue;
            return;
        }
        this.undef_helper(argName, this.globalDefdNames);
    }

    boolean undef_helper(String argName, HashMap<String, String> names) {
        if (names.containsKey(argName)) {
            names.remove(argName);
            return true;
        }
        return false;
    }

    class CharPos {
        char[] chars;
        int pos;

        CharPos(char[] c, int p) {
            this.chars = c;
            this.pos = p;
        }
    }

    class FilePos {
        int file;
        int line;
        int col;
        int sourceNum;

        FilePos(int file, int line, int col, int sourceNum) {
            this.file = file;
            this.line = line;
            this.col = col;
            this.sourceNum = sourceNum;
        }
    }

    class IncludeArg {
        String argName;
        String argVal;

        IncludeArg(String argName, String argVal) {
            this.argName = argName;
            this.argVal = argVal;
        }
    }
}

