/*
 * Decompiled with CFR 0.152.
 */
package com.joanju.proparse;

import com.joanju.proparse.Environment;
import com.joanju.proparse.NodeTypes;
import com.joanju.proparse.ProEvalException;
import com.joanju.proparse.StringFuncs;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class ProEvalSupport {
    static Boolean compare(Object left, Object right, Compare test) {
        Integer result = ProEvalSupport.compare(left, right);
        if (result == null) {
            if (test == Compare.NE) {
                return true;
            }
            return null;
        }
        switch (test) {
            case EQ: {
                if (result == 0) {
                    return true;
                }
                return false;
            }
            case GE: {
                if (result >= 0) {
                    return true;
                }
                return false;
            }
            case GT: {
                if (result > 0) {
                    return true;
                }
                return false;
            }
            case LE: {
                if (result <= 0) {
                    return true;
                }
                return false;
            }
            case LT: {
                if (result < 0) {
                    return true;
                }
                return false;
            }
            case NE: {
                if (result != 0) {
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException();
    }

    static Integer compare(Object left, Object right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return ((Boolean)left).compareTo((Boolean)right);
        }
        if (left instanceof String && right instanceof String) {
            return ProEvalSupport.compareStringHelper(left).compareTo(ProEvalSupport.compareStringHelper(right));
        }
        if (left instanceof Integer && right instanceof Integer) {
            return ((Integer)left).compareTo((Integer)right);
        }
        if (left instanceof Number && right instanceof Number) {
            Float fl = Float.valueOf(((Number)left).floatValue());
            Float fr = Float.valueOf(((Number)right).floatValue());
            return fl.compareTo(fr);
        }
        throw new ProEvalException("Incompatible data types in comparison expression.");
    }

    static String compareStringHelper(Object o) {
        return StringFuncs.rtrim(((String)o).toLowerCase());
    }

    static Float decimal(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof String) {
            return Float.valueOf(ProEvalSupport.getNumber((String)o).floatValue());
        }
        if (o instanceof Boolean) {
            return Float.valueOf((Boolean)o != false ? 1.0f : 0.0f);
        }
        throw new ProEvalException("Error converting to DECIMAL.");
    }

    static String entry(Object oa, Object ob, Object odelim) {
        if (oa == null || ob == null) {
            return null;
        }
        int pos = ProEvalSupport.getInt(oa);
        String b = ProEvalSupport.getString(ob);
        String delim = odelim == null ? "," : ProEvalSupport.getString(odelim);
        if (pos < 1) {
            throw new ProEvalException("ENTRY function received non-positive number");
        }
        Pattern regex = Pattern.compile(delim = delim.substring(0, 1), 18);
        String[] array = regex.split(b);
        if (pos > array.length) {
            return "";
        }
        return array[pos - 1];
    }

    static boolean getBool(Object obj) {
        if (obj instanceof String) {
            return ((String)obj).length() != 0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Integer) {
            return (Integer)obj != 0;
        }
        throw new ProEvalException("Unknown datatype passed to getBool");
    }

    static float getFloat(Object obj) {
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        throw new ProEvalException("Incompatible datatype");
    }

    static int getInt(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new ProEvalException("Incompatible datatype");
    }

    static Number getNumber(String s) {
        if (s.endsWith("-")) {
            s = "-" + s.substring(0, s.length() - 1);
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        try {
            if (s.indexOf(46) > -1) {
                return Float.valueOf(Float.parseFloat(s));
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new ProEvalException("Lexical cast to number from: " + s + " failed.");
        }
    }

    static String getString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new ProEvalException("Incompatible datatype");
    }

    static Integer index(Object x, Object y, Object z) {
        if (x == null || y == null) {
            return 0;
        }
        String a = ProEvalSupport.getString(x);
        String b = ProEvalSupport.getString(y);
        if (a.length() == 0 || b.length() == 0) {
            return 0;
        }
        int startIndex = 0;
        if (z != null) {
            startIndex = ProEvalSupport.getInt(z);
        }
        String source = a.toLowerCase();
        String target = b.toLowerCase();
        return source.indexOf(target, startIndex - 1) + 1;
    }

    static Integer integer(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return Math.round(((Number)o).floatValue());
        }
        if (o instanceof String) {
            return Math.round(ProEvalSupport.getNumber((String)o).floatValue());
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        throw new ProEvalException("Error converting to INTEGER.");
    }

    static String keyword(Object o) {
        String s = ProEvalSupport.getString(o);
        int ttype = -2;
        if ((ttype = NodeTypes.testLiteralsTable(s, ttype)) > 0 && NodeTypes.isReserved(ttype)) {
            return NodeTypes.getFullText(s);
        }
        return null;
    }

    static String keywordall(Object o) {
        String s = ProEvalSupport.getString(o);
        int ttype = -2;
        if ((ttype = NodeTypes.testLiteralsTable(s, ttype)) > 0 && NodeTypes.isKeywordType(ttype)) {
            return NodeTypes.getFullText(s);
        }
        return s.toUpperCase();
    }

    static String lefttrim(Object a, Object b) {
        if (b != null) {
            String t = ProEvalSupport.getString(b);
            return StringFuncs.ltrim(ProEvalSupport.getString(a), t);
        }
        return StringFuncs.ltrim(ProEvalSupport.getString(a));
    }

    static Integer lookup(Object x, Object y, Object z) {
        if (x == null || y == null) {
            return null;
        }
        String a = ProEvalSupport.getString(x);
        String b = ProEvalSupport.getString(y);
        if (a.length() == 0 && b.length() == 0) {
            return 1;
        }
        a = a.toLowerCase();
        b = b.toLowerCase();
        String delim = z == null ? "," : ((String)z).toLowerCase();
        Pattern regex = Pattern.compile(delim, 16);
        List<String> expr = Arrays.asList(regex.split(a));
        List<String> list = Arrays.asList(regex.split(b));
        if (expr.size() == 1) {
            return list.indexOf(a) + 1;
        }
        int exprSize = expr.size();
        int listSize = list.size();
        int index = 0;
        while (index < listSize) {
            int end = index + exprSize;
            if (end >= listSize) {
                return 0;
            }
            if (list.subList(index, end).equals(expr)) {
                return index + 1;
            }
            ++index;
        }
        return 0;
    }

    static Boolean matches(Object y, Object z) {
        String a = ProEvalSupport.getString(y).toLowerCase();
        String b = ProEvalSupport.getString(z).toLowerCase();
        if (b.length() == 1 && b.charAt(0) == '*') {
            return true;
        }
        if (a.length() == 0) {
            if (b.length() == 0) {
                return true;
            }
            return false;
        }
        if (b.length() == 0) {
            return false;
        }
        if (b.charAt(0) == '.') {
            return ProEvalSupport.matches(a.substring(1), b.substring(1));
        }
        if (b.charAt(0) == '*') {
            if (!ProEvalSupport.matches(a, b.substring(1)).booleanValue() && !ProEvalSupport.matches(a.substring(1), b).booleanValue()) {
                return false;
            }
            return true;
        }
        if (b.charAt(0) == '~') {
            if (a.charAt(0) == b.charAt(1) && ProEvalSupport.matches(a.substring(1), b.substring(2)).booleanValue()) {
                return true;
            }
            return false;
        }
        if (a.charAt(0) == b.charAt(0) && ProEvalSupport.matches(a.substring(1), b.substring(1)).booleanValue()) {
            return true;
        }
        return false;
    }

    public static Integer numentries(Object a, Object b) {
        String sa = ProEvalSupport.getString(a);
        if (sa.length() == 0) {
            return 0;
        }
        String sb = b != null ? ProEvalSupport.getString(b) : ",";
        Pattern regex = Pattern.compile(sb, 18);
        return regex.split(sa, -2).length;
    }

    static Object opDivide(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return (Integer)left / (Integer)right;
        }
        if (left instanceof Number && right instanceof Number) {
            Float fl = Float.valueOf(((Number)left).floatValue());
            Float fr = Float.valueOf(((Number)right).floatValue());
            return Float.valueOf(fl.floatValue() / fr.floatValue());
        }
        throw new ProEvalException("Incompatible data type in expression.");
    }

    static Object opMinus(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return (Integer)left - (Integer)right;
        }
        if (left instanceof Number && right instanceof Number) {
            Float fl = Float.valueOf(((Number)left).floatValue());
            Float fr = Float.valueOf(((Number)right).floatValue());
            return Float.valueOf(fl.floatValue() - fr.floatValue());
        }
        throw new ProEvalException("Incompatible data type in expression.");
    }

    static Object opMultiply(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return (Integer)left * (Integer)right;
        }
        if (left instanceof Number && right instanceof Number) {
            Float fl = Float.valueOf(((Number)left).floatValue());
            Float fr = Float.valueOf(((Number)right).floatValue());
            return Float.valueOf(fl.floatValue() * fr.floatValue());
        }
        throw new ProEvalException("Incompatible data type in expression.");
    }

    static Object opPlus(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof String && right instanceof String) {
            return String.valueOf((String)left) + right;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return (Integer)left + (Integer)right;
        }
        if (left instanceof Number && right instanceof Number) {
            Float fl = Float.valueOf(((Number)left).floatValue());
            Float fr = Float.valueOf(((Number)right).floatValue());
            return Float.valueOf(fl.floatValue() + fr.floatValue());
        }
        throw new ProEvalException("Incompatible data type in expression.");
    }

    static String propath() {
        StringBuilder bldr = new StringBuilder();
        boolean delim = false;
        for (String p : Environment.instance().path) {
            if (delim) {
                bldr.append(',');
            }
            bldr.append(p);
            delim = true;
        }
        return bldr.toString();
    }

    static String replace(String source, String from, String to) {
        Pattern regex = Pattern.compile(from, 18);
        return regex.matcher(source).replaceAll(to);
    }

    static Integer rindex(Object a, Object b, Object c) {
        String source = ProEvalSupport.getString(a).toLowerCase();
        String target = ProEvalSupport.getString(b).toLowerCase();
        if (source.length() == 0 || target.length() == 0) {
            return 0;
        }
        if (c != null) {
            return source.lastIndexOf(target, ProEvalSupport.getInt(c) - 1) + 1;
        }
        return source.lastIndexOf(target) + 1;
    }

    static String string(Object a) {
        if (a == null) {
            return "?";
        }
        if (a instanceof Boolean) {
            return (Boolean)a != false ? "yes" : "no";
        }
        return a.toString();
    }

    static String substring(Object a, Object b, Object c) {
        String str = ProEvalSupport.getString(a);
        int pos = ProEvalSupport.getInt(b) - 1;
        if (pos >= str.length()) {
            return "";
        }
        int len = -1;
        if (c != null) {
            len = ProEvalSupport.getInt(c);
        }
        if (len == -1) {
            return str.substring(pos);
        }
        int endpos = pos + len;
        if (endpos > str.length()) {
            endpos = str.length();
        }
        return str.substring(pos, endpos);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Compare {
        EQ,
        NE,
        GT,
        GE,
        LT,
        LE;

    }
}

