/*
 * Decompiled with CFR 0.152.
 */
package com.joanju.proparse;

import antlr.CommonHiddenStreamToken;
import com.joanju.DataXferStream;
import com.joanju.Xferable;
import com.joanju.proparse.IntegerIndex;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProToken
extends CommonHiddenStreamToken
implements Xferable {
    int fileIndex;
    int macroSourceNum;
    IntegerIndex<String> filenameList;

    public ProToken() {
    }

    public ProToken(IntegerIndex<String> filenameList, int type, String s) {
        super(type, s);
        this.filenameList = filenameList;
    }

    public ProToken(IntegerIndex<String> filenameList, int type, String txt, int file, int line, int col, int macroSourceNum) {
        super(type, txt);
        this.filenameList = filenameList;
        this.fileIndex = file;
        this.macroSourceNum = macroSourceNum;
        this.line = line;
        this.col = col;
    }

    public ProToken(ProToken orig) {
        super(orig.getType(), orig.getText());
        this.filenameList = orig.filenameList;
        this.fileIndex = orig.fileIndex;
        this.macroSourceNum = orig.macroSourceNum;
        this.line = orig.line;
        this.col = orig.col;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public IntegerIndex<String> getFilenameList() {
        return this.filenameList;
    }

    public String getFilename() {
        if (this.filenameList == null || this.fileIndex < 0 || this.fileIndex > this.filenameList.size()) {
            return "";
        }
        String ret = this.filenameList.getValue(this.fileIndex);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public int getMacroSourceNum() {
        return this.macroSourceNum;
    }

    public ProToken getNext() {
        return (ProToken)this.getHiddenAfter();
    }

    public ProToken getPrev() {
        return (ProToken)this.getHiddenBefore();
    }

    public void setHiddenAfter(ProToken t) {
        super.setHiddenAfter((CommonHiddenStreamToken)t);
    }

    public void setHiddenBefore(ProToken t) {
        super.setHiddenBefore((CommonHiddenStreamToken)t);
    }

    public void setFileIndex(int fileIndex) {
        this.fileIndex = fileIndex;
    }

    public void setFilenameList(IntegerIndex<String> filenameList) {
        this.filenameList = filenameList;
    }

    public void setMacroSourceNum(int macroSourceNum) {
        this.macroSourceNum = macroSourceNum;
    }

    @Override
    public void writeXferBytes(DataXferStream out) throws IOException {
        out.writeInt(this.getType());
        out.writeInt(this.getMacroSourceNum());
        out.writeInt(this.getFileIndex());
        out.writeInt(this.getLine());
        out.writeInt(this.getColumn());
        out.writeRef(this.getText());
    }

    @Override
    public void writeXferSchema(DataXferStream out) throws IOException {
        out.schemaInt("type");
        out.schemaInt("macroSourceNum");
        out.schemaInt("fileIndex");
        out.schemaInt("line");
        out.schemaInt("column");
        out.schemaRef("text");
    }
}

