/*
 * Decompiled with CFR 0.152.
 */
package com.joanju.proparse;

import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringFuncs {
    public static String escapeLineBreaks(String s) {
        String ret = s.replace("\\", "\\\\");
        ret = ret.replace("\n", "\\n");
        ret = ret.replace("\r", "\\r");
        return ret;
    }

    public static String ltrim(String s) {
        char[] c = s.toCharArray();
        int begin = 0;
        int end = c.length;
        while (begin < end && Character.isWhitespace(c[begin])) {
            ++begin;
        }
        return s.substring(begin);
    }

    public static String ltrim(String s, String t) {
        HashSet<Character> trimSet = StringFuncs.setOfMatchChars(t);
        char[] c = s.toCharArray();
        int begin = 0;
        int end = c.length;
        while (begin < end && trimSet.contains(Character.valueOf(c[begin]))) {
            ++begin;
        }
        return s.substring(begin);
    }

    public static String qstringStrip(String s) {
        if (s.length() < 2) {
            return s;
        }
        char quoteType = s.charAt(0);
        if (quoteType != '\"' && quoteType != '\'') {
            return s;
        }
        int endQuotePos = s.lastIndexOf(quoteType);
        if (endQuotePos < 1) {
            return s;
        }
        return s.substring(1, endQuotePos);
    }

    static HashSet<Character> setOfMatchChars(String s) {
        char c;
        HashSet<Character> set = new HashSet<Character>();
        char[] cArray = s.toLowerCase().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            set.add(Character.valueOf(c));
            ++n2;
        }
        cArray = s.toUpperCase().toCharArray();
        n = cArray.length;
        n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            set.add(Character.valueOf(c));
            ++n2;
        }
        return set;
    }

    public static String stripComments(String orig) {
        StringBuilder bldr = new StringBuilder();
        int it = 0;
        int commentLevel = 0;
        char[] c = orig.toCharArray();
        int end = c.length;
        char curr = '\u0000';
        while (it < end) {
            char next;
            char prev = curr;
            curr = c[it];
            char c2 = next = ++it < end ? c[it] : (char)'\u0000';
            if (commentLevel > 0 && curr == '/' && prev == '*') {
                --commentLevel;
                continue;
            }
            if (curr == '/' && next == '*') {
                ++commentLevel;
                continue;
            }
            if (commentLevel != 0) continue;
            bldr.append(curr);
        }
        return bldr.toString();
    }

    public static String rtrim(String s) {
        char[] c = s.toCharArray();
        int end = c.length;
        while (end > 0 && Character.isWhitespace(c[end - 1])) {
            --end;
        }
        return s.substring(0, end);
    }

    public static String rtrim(String s, String t) {
        HashSet<Character> trimSet = StringFuncs.setOfMatchChars(t);
        char[] c = s.toCharArray();
        int end = c.length;
        while (end > 0 && trimSet.contains(Character.valueOf(c[end - 1]))) {
            --end;
        }
        return s.substring(0, end);
    }

    public static String trim(String s, String t) {
        HashSet<Character> trimSet = StringFuncs.setOfMatchChars(t);
        char[] c = s.toCharArray();
        int begin = 0;
        int end = c.length;
        while (begin < end && trimSet.contains(Character.valueOf(c[begin]))) {
            ++begin;
        }
        while (end >= begin && trimSet.contains(Character.valueOf(c[end - 1]))) {
            --end;
        }
        return s.substring(begin, end);
    }
}

