/*
 * Decompiled with CFR 0.152.
 */
package com.joanju.proparse;

import java.util.HashMap;
import java.util.HashSet;
import org.prorefactor.core.schema.Schema;
import org.prorefactor.core.schema.Table;

public class SymbolScope {
    private String scopeName;
    private HashMap<String, TableRef> tableMap = new HashMap();
    private HashSet<String> functionSet = new HashSet();
    private HashSet<String> methodSet = new HashSet();
    private HashSet<String> varSet = new HashSet();
    private Schema schema = Schema.getInstance();
    private SymbolScope superScope;

    SymbolScope() {
    }

    SymbolScope(SymbolScope superScope) {
        this.superScope = superScope;
    }

    void defBuffer(String bufferName, String tableName) {
        tableName = tableName.toLowerCase();
        FieldType bufferType = this.isTableSchemaFirst(tableName);
        bufferName = bufferName.toLowerCase();
        TableRef newRef = new TableRef();
        newRef.bufferFor = tableName;
        newRef.tableType = bufferType;
        this.tableMap.put(bufferName, newRef);
        if (newRef.tableType == FieldType.DBTABLE) {
            Table table = this.schema.lookupTable(tableName);
            if (table != null) {
                newRef.dbName = table.getDatabase().getName();
                newRef.fullName = String.valueOf(newRef.dbName) + "." + table.getName();
            }
            Table.Name tn = new Table.Name(tableName);
            String dbRefName = String.valueOf(tn.db != null ? tn.db : table.getDatabase().getName()) + "." + bufferName;
            TableRef dbRef = new TableRef();
            dbRef.bufferFor = tableName;
            dbRef.tableType = bufferType;
            this.tableMap.put(dbRefName, dbRef);
        }
    }

    void defFunc(String name) {
        this.functionSet.add(name.toLowerCase());
    }

    void defMethod(String name) {
        this.methodSet.add(name.toLowerCase());
    }

    void defTable(String name, FieldType ttype) {
        TableRef newTable = new TableRef();
        newTable.tableType = ttype;
        this.tableMap.put(name.toLowerCase(), newTable);
    }

    void defVar(String name) {
        this.varSet.add(name.toLowerCase());
    }

    String getScopeName() {
        return this.scopeName;
    }

    SymbolScope getSuperScope() {
        return this.superScope;
    }

    FieldType isTable(String inName) {
        Table table = this.schema.lookupTable(inName);
        if (table != null && inName.contains(".")) {
            return FieldType.DBTABLE;
        }
        FieldType ret = this.isTableDef(inName);
        if (ret != null) {
            return ret;
        }
        if (table != null) {
            return FieldType.DBTABLE;
        }
        if (inName.equals("proc-text-buffer")) {
            return FieldType.TTABLE;
        }
        return null;
    }

    FieldType isTableDef(String inName) {
        if (this.tableMap.containsKey(inName)) {
            return this.tableMap.get((Object)inName).tableType;
        }
        if (this.superScope != null) {
            return this.superScope.isTableDef(inName);
        }
        return null;
    }

    FieldType isTableSchemaFirst(String inName) {
        Table table = this.schema.lookupTable(inName);
        if (table != null) {
            Table.Name name = new Table.Name(inName);
            if (table.getName().length() == name.table.length()) {
                return FieldType.DBTABLE;
            }
        }
        return this.isTable(inName);
    }

    boolean isVar(String name) {
        if (this.varSet.contains(name.toLowerCase())) {
            return true;
        }
        if (this.superScope != null) {
            return this.superScope.isVar(name);
        }
        return false;
    }

    int methodOrFunc(String name) {
        String lname = name.toLowerCase();
        if (this.methodSet.contains(lname)) {
            return 1129;
        }
        if (this.functionSet.contains(lname)) {
            return 997;
        }
        if (this.superScope != null) {
            return this.superScope.methodOrFunc(name);
        }
        return 0;
    }

    void setScopeName(String inName) {
        this.scopeName = inName;
    }

    SymbolScope setSuperScope(SymbolScope superScope) {
        this.superScope = superScope;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FieldType {
        VARIABLE(1),
        DBTABLE(2),
        TTABLE(3),
        WTABLE(4);

        int intval;

        private FieldType(int intval) {
            this.intval = intval;
        }
    }

    private class TableRef {
        FieldType tableType;
        String bufferFor;
        String fullName;
        String dbName;

        private TableRef() {
        }
    }
}

