/*
 * Decompiled with CFR 0.152.
 */
package com.joanju.proparse.sockets;

import com.joanju.DataXferStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.prorefactor.core.TreeUtils;
import org.prorefactor.refactor.RefactorException;
import org.prorefactor.treeparser.ParseUnit;

public class BlobBuilder {
    private ByteArrayOutputStream headerBytes = new ByteArrayOutputStream();
    private DataOutputStream header = new DataOutputStream(this.headerBytes);
    private DataXferStream xfer = new DataXferStream();
    private String filename;
    private static int proparseBuildNum = 0;

    static {
        BlobBuilder.setBuildNumFromJar();
    }

    BlobBuilder(String filename) {
        this.filename = filename;
    }

    public void build() throws RefactorException, IOException {
        ParseUnit pu = new ParseUnit(new File(this.filename));
        pu.treeParser01();
        pu.getMacroGraph();
        int sourceFilesOffset = this.xfer.store(pu.getFileIndex());
        int nodesOffset = this.xfer.store(TreeUtils.nodeArray(pu.getTopNode()));
        int rootScopeOffset = this.xfer.store(pu.getRootScope());
        int macroSourcesOffset = this.xfer.store(pu.getMacroSourceArray());
        this.xfer.buildIndexes();
        this.header.writeInt(sourceFilesOffset);
        this.header.writeInt(nodesOffset);
        this.header.writeInt(rootScopeOffset);
        this.header.writeInt(macroSourcesOffset);
        this.header.writeInt(this.xfer.getSchemaMapOffset());
        this.header.writeInt(this.xfer.getIndexOffset());
        this.header.writeInt(proparseBuildNum);
    }

    public ByteArrayOutputStream getBlob() {
        return this.xfer.getBytes();
    }

    public ByteArrayOutputStream getHeader() {
        return this.headerBytes;
    }

    public static int getBuildNumber() {
        return proparseBuildNum;
    }

    private static void setBuildNumFromJar() {
        JarFile jarFile = null;
        try {
            URL jarURL = BlobBuilder.class.getClassLoader().getResource("com/joanju/proparse/sockets");
            JarURLConnection jurlConn = (JarURLConnection)jarURL.openConnection();
            jarFile = jurlConn.getJarFile();
        }
        catch (Throwable e) {
            try {
                jarFile = new JarFile("../ant/proparse.jar");
            }
            catch (IOException e1) {
                System.out.println(e1);
            }
        }
        if (jarFile == null) {
            return;
        }
        Manifest mf = null;
        try {
            mf = jarFile.getManifest();
            Attributes attr = mf.getAttributes("Proparse");
            String buildString = attr.getValue("Build");
            proparseBuildNum = Integer.parseInt(buildString);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

