/*
 * Decompiled with CFR 0.152.
 */
package com.joanju.proparse.sockets;

import com.joanju.DataXferStream;
import com.joanju.Xferable;
import com.joanju.proparse.NodeTypes;
import com.joanju.proparse.ProToken;
import com.joanju.proparse.sockets.BlobBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.schema.Database;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.Table;
import org.prorefactor.macrolevel.IncludeRef;
import org.prorefactor.macrolevel.MacroDef;
import org.prorefactor.macrolevel.NamedMacroRef;
import org.prorefactor.nodetypes.BlockNode;
import org.prorefactor.nodetypes.FieldRefNode;
import org.prorefactor.nodetypes.ProgramRootNode;
import org.prorefactor.nodetypes.ProparseDirectiveNode;
import org.prorefactor.nodetypes.RecordNameNode;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.treeparser.Block;
import org.prorefactor.treeparser.BufferScope;
import org.prorefactor.treeparser.DataType;
import org.prorefactor.treeparser.Dataset;
import org.prorefactor.treeparser.Datasource;
import org.prorefactor.treeparser.FieldBuffer;
import org.prorefactor.treeparser.Query;
import org.prorefactor.treeparser.Routine;
import org.prorefactor.treeparser.Stream;
import org.prorefactor.treeparser.SymbolScope;
import org.prorefactor.treeparser.SymbolScopeRoot;
import org.prorefactor.treeparser.SymbolScopeSuper;
import org.prorefactor.treeparser.TableBuffer;
import org.prorefactor.treeparser.Variable;
import org.prorefactor.widgettypes.Browse;
import org.prorefactor.widgettypes.Button;
import org.prorefactor.widgettypes.Frame;
import org.prorefactor.widgettypes.Image;
import org.prorefactor.widgettypes.Menu;
import org.prorefactor.widgettypes.MenuItem;
import org.prorefactor.widgettypes.Rectangle;
import org.prorefactor.widgettypes.Submenu;

public class SocketListener
implements Runnable {
    Socket socket;
    ByteArrayOutputStream stringsBytes = new ByteArrayOutputStream();
    DataOutputStream strings = new DataOutputStream(this.stringsBytes);

    public SocketListener(Socket socket) {
        this.socket = socket;
    }

    public void run() {
        block16: {
            DataOutputStream out = null;
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                out = new DataOutputStream(this.socket.getOutputStream());
                String input = in.readLine();
                if (input == null) {
                    return;
                }
                if (input.trim().equalsIgnoreCase("--allschema")) {
                    DataXferStream xfer = this.allSchema();
                    xfer.buildIndexes();
                    out.writeInt(xfer.size());
                    xfer.getBytes().writeTo(out);
                } else if (input.toLowerCase().startsWith("--buildnum")) {
                    out.writeInt(BlobBuilder.getBuildNumber());
                } else if (input.toLowerCase().startsWith("--loadproject")) {
                    this.loadProject(input);
                    out.writeInt(0);
                } else if (input.trim().equalsIgnoreCase("--nodetypes")) {
                    DataXferStream xfer = new DataXferStream();
                    xfer.store(new NodeTypes());
                    xfer.buildIndexes();
                    out.writeInt(xfer.size());
                    xfer.getBytes().writeTo(out);
                } else if (input.trim().equalsIgnoreCase("--shutdown")) {
                    System.out.println("Shutdown requested by client.");
                    System.exit(0);
                } else {
                    BlobBuilder builder = new BlobBuilder(input);
                    builder.build();
                    ByteArrayOutputStream header = builder.getHeader();
                    out.writeInt(header.size());
                    header.writeTo(out);
                    ByteArrayOutputStream blob = builder.getBlob();
                    out.writeInt(blob.size());
                    blob.writeTo(out);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String errmsg = e.getMessage();
                if (out == null) break block16;
                try {
                    if (errmsg == null || errmsg.length() == 0) {
                        errmsg = e.toString();
                    }
                    byte[] bytes = errmsg.getBytes();
                    out.writeInt(bytes.length * -1);
                    out.write(bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private DataXferStream allSchema() throws Exception {
        DataXferStream xfer = new DataXferStream();
        xfer.addSchemaFor((Xferable)ProToken.class.newInstance());
        xfer.addSchemaFor((Xferable)JPNode.class.newInstance());
        xfer.addSchemaFor((Xferable)Database.class.newInstance());
        xfer.addSchemaFor((Xferable)Field.class.newInstance());
        xfer.addSchemaFor((Xferable)Table.class.newInstance());
        xfer.addSchemaFor((Xferable)IncludeRef.class.newInstance());
        xfer.addSchemaFor((Xferable)MacroDef.class.newInstance());
        xfer.addSchemaFor((Xferable)NamedMacroRef.class.newInstance());
        xfer.addSchemaFor((Xferable)BlockNode.class.newInstance());
        xfer.addSchemaFor((Xferable)FieldRefNode.class.newInstance());
        xfer.addSchemaFor((Xferable)ProgramRootNode.class.newInstance());
        xfer.addSchemaFor((Xferable)ProparseDirectiveNode.class.newInstance());
        xfer.addSchemaFor((Xferable)RecordNameNode.class.newInstance());
        xfer.addSchemaFor((Xferable)Block.class.newInstance());
        xfer.addSchemaFor((Xferable)BufferScope.class.newInstance());
        xfer.addSchemaFor((Xferable)Dataset.class.newInstance());
        xfer.addSchemaFor((Xferable)Datasource.class.newInstance());
        xfer.addSchemaFor((Xferable)DataType.class.newInstance());
        xfer.addSchemaFor((Xferable)FieldBuffer.class.newInstance());
        xfer.addSchemaFor((Xferable)Query.class.newInstance());
        xfer.addSchemaFor((Xferable)Routine.class.newInstance());
        xfer.addSchemaFor((Xferable)Stream.class.newInstance());
        xfer.addSchemaFor((Xferable)SymbolScope.class.newInstance());
        xfer.addSchemaFor((Xferable)SymbolScopeRoot.class.newInstance());
        xfer.addSchemaFor((Xferable)SymbolScopeSuper.class.newInstance());
        xfer.addSchemaFor((Xferable)TableBuffer.class.newInstance());
        xfer.addSchemaFor((Xferable)Variable.class.newInstance());
        xfer.addSchemaFor((Xferable)Browse.class.newInstance());
        xfer.addSchemaFor((Xferable)Button.class.newInstance());
        xfer.addSchemaFor((Xferable)Frame.class.newInstance());
        xfer.addSchemaFor((Xferable)Image.class.newInstance());
        xfer.addSchemaFor((Xferable)Menu.class.newInstance());
        xfer.addSchemaFor((Xferable)MenuItem.class.newInstance());
        xfer.addSchemaFor((Xferable)Rectangle.class.newInstance());
        xfer.addSchemaFor((Xferable)Submenu.class.newInstance());
        return xfer;
    }

    private void loadProject(String message) throws Exception {
        String projectName = message.substring(13).trim();
        System.out.println("Proparse Server: Client requested load project: " + projectName);
        System.out.flush();
        RefactorSession.getInstance().loadProject(projectName);
    }
}

