/*
 * Decompiled with CFR 0.152.
 */
package org.proparse.api;

import java.util.HashMap;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.PRCException;
import org.prorefactor.core.TreeUtils;

public class Backward {
    int nextHandle = 1;
    HashMap<Integer, JPNode> handles = new HashMap();
    HashMap<String, JPNode[]> queries = new HashMap();

    private void checkHandle(int h) throws PRCException {
        if (!this.handles.containsKey(h)) {
            throw new PRCException("Reference to invalid node handle");
        }
    }

    private void checkNode(int h) throws PRCException {
        this.checkHandle(h);
        if (this.handles.get(h) == null) {
            throw new PRCException("Reference to handle with no node");
        }
    }

    public void clear() {
        this.handles.clear();
        this.queries.clear();
        this.nextHandle = 1;
    }

    public void copyHandle(int from, int to) throws PRCException {
        this.checkHandle(from);
        this.checkHandle(to);
        this.handles.put(to, this.handles.get(from));
    }

    public int getHandle() {
        this.handles.put(this.nextHandle, null);
        return this.nextHandle++;
    }

    public JPNode getNode(int h) throws PRCException {
        this.checkNode(h);
        return this.handles.get(h);
    }

    public void setHandle(int h, JPNode n) {
        this.handles.put(h, n);
    }

    public void queryClear(String queryName) {
        if (queryName.equals("")) {
            this.queries.clear();
        } else {
            this.queries.remove(queryName);
        }
    }

    public JPNode[] queryCreate(int fromHandle, String queryName, String typeName) throws PRCException {
        String lname = queryName.toLowerCase();
        this.checkNode(fromHandle);
        JPNode[] ret = typeName.equals("") ? TreeUtils.flatListAsArray(this.handles.get(fromHandle)) : this.handles.get(fromHandle).query(typeName);
        this.queries.put(lname, ret);
        return ret;
    }

    public JPNode[] queryGet(String queryName) throws PRCException {
        String lname = queryName.toLowerCase();
        if (!this.queries.containsKey(lname)) {
            throw new PRCException("Invalid query name");
        }
        return this.queries.get(lname);
    }

    public void queryGetResult(String queryName, int resultNum, int intoHandle) throws PRCException {
        JPNode[] nodes = this.queryGet(queryName);
        if (resultNum < 0 || resultNum > nodes.length) {
            throw new PRCException("Request for query result number out of range");
        }
        this.setHandle(intoHandle, nodes[resultNum - 1]);
    }
}

