/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.prorefactor.io.LogWriter;
import org.prorefactor.refactor.PUB;
import org.prorefactor.refactor.RefactorException;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.reports.HowUsedConsole;
import org.prorefactor.reports.WhereUsedConsole;
import org.prorefactor.treeparser.ParseUnit;

public class Console {
    protected BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    protected RefactorSession session = RefactorSession.getInstance();

    public static void main(String[] args) {
        new Console().uiLoop();
    }

    public void uiLoop() {
        try {
            String choice = "";
            while (!choice.equalsIgnoreCase("q")) {
                System.out.println();
                this.showMenu();
                choice = this.menuSelect();
                if (choice == null) continue;
                this.processSelection(choice);
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void processSelection(String choice) throws Exception {
        if (choice.equalsIgnoreCase("h")) {
            this.howUsedReport();
        } else if (choice.equalsIgnoreCase("l")) {
            this.loadProjectSettings();
        } else if (choice.equalsIgnoreCase("p")) {
            this.parseDirectory();
        } else if (choice.equalsIgnoreCase("w")) {
            this.whereUsedReport();
        }
    }

    public Collection buildCUListFromFile(String listFileName) throws IOException {
        System.out.println("Reading files list...");
        BufferedReader cuList = new BufferedReader(new FileReader(new File(listFileName)));
        ArrayList<File> ret = new ArrayList<File>();
        String cuName = "";
        while (cuName != null) {
            if ((cuName = cuName.trim()).length() != 0) {
                File cuFile = new File(cuName);
                if (!cuFile.exists()) {
                    throw new IOException("File does not exist: " + cuName);
                }
                ret.add(cuFile);
            }
            cuName = cuList.readLine();
        }
        return ret;
    }

    protected void checkProjectIsLoaded() throws Exception {
        String projName = this.session.getProjectName();
        while (projName == null || projName.length() == 0) {
            System.out.println("No project loaded.");
            this.loadProjectSettings();
            projName = this.session.getProjectName();
        }
    }

    public Collection findCompileUnits(File dir) {
        String[] extensions = new String[]{"p", "w", "cls"};
        System.out.println("Finding files...");
        Collection files = FileUtils.listFiles((File)dir, (String[])extensions, (boolean)true);
        return files;
    }

    private void howUsedReport() throws Exception {
        this.checkProjectIsLoaded();
        new HowUsedConsole().go();
    }

    protected void loadProjectSettings() throws Exception {
        System.out.print("Project name to load settings for: ");
        String projectName = this.reader.readLine();
        if (projectName == null || projectName.length() == 0) {
            return;
        }
        this.session.loadProject(projectName);
    }

    protected String menuSelect() throws IOException {
        System.out.print("Enter selection: ");
        String choice = this.reader.readLine();
        return choice;
    }

    private void parseDirectory() throws Exception {
        this.checkProjectIsLoaded();
        System.out.println("Enter the directory to parse.");
        File dir = this.promptDirectory();
        if (dir == null) {
            return;
        }
        LogWriter log = new LogWriter(System.out);
        try {
            Collection files = this.findCompileUnits(dir);
            int currFileNum = 0;
            String totalFiles = "/" + files.size() + " ";
            for (File cuFile : files) {
                String logMsg = String.valueOf(Integer.toString(++currFileNum)) + totalFiles + cuFile.toString();
                ParseUnit pu = new ParseUnit(cuFile);
                PUB pub = pu.getPUB();
                pub.loadTo(15);
                if (pub.isCurrent()) {
                    log.log(String.valueOf(logMsg) + " PUB is current");
                    continue;
                }
                log.log(String.valueOf(logMsg) + " parse");
                try {
                    pu.treeParser01();
                }
                catch (RefactorException e) {
                    log.logException(cuFile.toString(), e);
                }
            }
        }
        finally {
            log.close();
        }
    }

    protected File promptDirectory() throws IOException {
        System.out.print("Directory: ");
        String dirName = this.reader.readLine();
        if (dirName == null || dirName.length() == 0) {
            return null;
        }
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            System.out.println(String.valueOf(dirName) + " is not a directory.");
            return null;
        }
        return dir;
    }

    protected void showMenu() {
        System.out.println("h) How-used report \nl) Load Settings for a project \np) Parse a directory \nq) Quit \nw) Where used report \n");
    }

    private void whereUsedReport() throws Exception {
        this.checkProjectIsLoaded();
        new WhereUsedConsole().go();
    }
}

