/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core;

import java.util.ArrayList;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.PositionIndex;

public class CodeSelect {
    private int currBranch = -1;
    private ArrayList stack = new ArrayList();
    private JPNode startingNode;

    public CodeSelect(int file, int line, int col, PositionIndex index) {
        this.startingNode = index.getNodeFrom(file, line, col);
        if (this.startingNode == null) {
            return;
        }
        this.stack.add(this.startingNode);
        JPNode n = this.startingNode.parent();
        while (n != null) {
            this.stack.add(n);
            n = n.parent();
        }
    }

    public JPNode contract() {
        if (this.currBranch < 1) {
            return null;
        }
        JPNode node = (JPNode)this.stack.get(--this.currBranch);
        return node;
    }

    public static int[] branchEndPos(JPNode node) {
        JPNode end = node.lastDescendant();
        if (end == null) {
            return null;
        }
        return new int[]{end.getFileIndex(), end.getLine(), end.getColumn() + end.getText().length()};
    }

    public JPNode expand() {
        if (this.currBranch + 1 > this.stack.size() - 1) {
            return null;
        }
        JPNode node = (JPNode)this.stack.get(++this.currBranch);
        return node;
    }
}

