/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.TokenTypesI;

public class JPNodeLister {
    public boolean showColumn = false;
    public boolean showFilename = false;
    public boolean showLinenum = false;
    public boolean showStoretype = false;
    public String lineSep = System.getProperty("line.separator");
    private int indentby = 4;
    private int indentnum = 0;
    private FileWriter ofile;
    private HashMap<Integer, String> indentStrings = new HashMap();
    private JPNode topNode;
    private String outfilename;
    protected String spacer = "    ";
    protected TokenTypesI tokenTypes = null;

    public JPNodeLister(JPNode topNode, String outfilename, TokenTypesI tokenTypes) {
        this.topNode = topNode;
        this.outfilename = outfilename;
        this.tokenTypes = tokenTypes;
    }

    protected String generateLineText(JPNode node) {
        String storetype;
        StringBuilder buff = new StringBuilder();
        buff.append(this.indent()).append(this.tokenTypes.getName(node.getType())).append(this.spacer).append(node.getText()).append(this.spacer);
        if (this.showLinenum) {
            buff.append(node.getLine()).append(" ");
        }
        if (this.showColumn) {
            buff.append(node.getColumn()).append(" ");
        }
        if (this.showFilename) {
            buff.append(node.getFilename()).append(this.spacer);
        }
        if (this.showStoretype && (storetype = node.attrGetS(1100)).length() != 0) {
            buff.append(storetype).append(this.spacer);
        }
        return buff.toString();
    }

    protected final String indent() {
        String indent = this.indentStrings.get(this.indentnum);
        if (indent == null) {
            char[] indentArray = new char[this.indentnum];
            Arrays.fill(indentArray, ' ');
            indent = new String(indentArray);
            this.indentStrings.put(this.indentnum, indent);
        }
        return indent;
    }

    public void print() throws IOException {
        this.ofile = new FileWriter(this.outfilename);
        this.print_sub(this.topNode);
        this.ofile.close();
    }

    private void print_sub(JPNode node) throws IOException {
        this.printline(node);
        JPNode child = node.firstChild();
        this.indentnum += this.indentby;
        while (child != null) {
            if (child.firstChild() != null) {
                this.print_sub(child);
            } else {
                this.printline(child);
            }
            child = child.nextSibling();
        }
        this.indentnum -= this.indentby;
    }

    private void printline(JPNode node) throws IOException {
        this.ofile.write(this.generateLineText(node));
        this.ofile.write(this.lineSep);
    }

    public JPNodeLister setIndentby(int indentby) {
        this.indentby = indentby;
        return this;
    }

    protected JPNodeLister setSpacer(String spacer) {
        this.spacer = spacer;
        return this;
    }
}

