/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.prorefactor.core.JPNode;

public class PositionIndex {
    private SortedSet nodeSet = new TreeSet(FILE_POSITION);
    private static final Comparator FILE_POSITION = new Comparator(){

        public int compare(Object o1, Object o2) {
            JPNode n1 = (JPNode)o1;
            JPNode n2 = (JPNode)o2;
            int ret = n1.getFileIndex() - n2.getFileIndex();
            if (ret != 0) {
                return ret;
            }
            ret = n1.getLine() - n2.getLine();
            if (ret != 0) {
                return ret;
            }
            return n1.getColumn() - n2.getColumn();
        }
    };

    public void addNode(JPNode node) {
        this.nodeSet.add(node);
    }

    public JPNode getNodeFrom(int file, int line, int col) {
        SortedSet<JPNode> tailSet = this.nodeSet.tailSet(new JPNode(file, line, col));
        if (tailSet.size() == 0) {
            return null;
        }
        return tailSet.first();
    }
}

