/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core;

import com.joanju.proparse.ProToken;
import java.util.ArrayList;
import org.prorefactor.core.JPNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeUtils {
    private ArrayList<JPNode> nodeList;

    public static ArrayList<JPNode> flatList(JPNode top) {
        return new FlatListBuilder().build(top);
    }

    public static JPNode[] flatListAsArray(JPNode top) {
        ArrayList<JPNode> list = TreeUtils.flatList(top);
        JPNode[] ret = new JPNode[list.size()];
        list.toArray(ret);
        return ret;
    }

    public static String fullPreproText(JPNode top) {
        ArrayList<JPNode> list = TreeUtils.flatList(top);
        StringBuilder bldr = new StringBuilder();
        for (JPNode node : list) {
            ProToken t = node.getHiddenFirst();
            while (t != null) {
                int type = t.getType();
                if (type == 907 || type == 906) {
                    bldr.append(t.getText());
                }
                t = t.getNext();
            }
            bldr.append(node.getText());
        }
        return bldr.toString();
    }

    public static JPNode[] nodeArray(JPNode top) {
        TreeUtils instance = new TreeUtils();
        instance.nodeList = new ArrayList();
        instance.nodeArray2(top);
        JPNode[] ret = new JPNode[instance.nodeList.size()];
        return instance.nodeList.toArray(ret);
    }

    private void nodeArray2(JPNode node) {
        if (node == null) {
            return;
        }
        this.nodeList.add(node);
        this.nodeArray2(node.firstChild());
        this.nodeArray2(node.nextSibling());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FlatListBuilder {
        ArrayList<JPNode> list = new ArrayList();

        private FlatListBuilder() {
        }

        ArrayList<JPNode> build(JPNode node) {
            this.walker(node, false);
            return this.list;
        }

        private void walker(JPNode node, boolean showSiblings) {
            if (node == null) {
                return;
            }
            if (node.attrGet(1200) == 1) {
                this.walker(node.firstChild(), false);
                this.list.add(node);
                this.walker(node.firstChild().nextSibling(), true);
            } else {
                this.list.add(node);
                this.walker(node.firstChild(), true);
            }
            if (showSiblings) {
                this.walker(node.nextSibling(), true);
            }
        }
    }
}

