/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class Util {
    public static final String LINESEP = System.getProperty("line.separator");

    public static void copyAllFiles(File sourceDir, File targetDir) throws IOException {
        if (!sourceDir.exists() || !sourceDir.isDirectory()) {
            throw new IOException(String.valueOf(sourceDir.toString()) + " does not exist or is not a directory.");
        }
        if (targetDir.exists() && !targetDir.isDirectory()) {
            throw new IOException(String.valueOf(targetDir.toString()) + " is not a directory.");
        }
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new IOException("Could not create directory " + targetDir.toString());
        }
        File[] files = sourceDir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                Util.fileCopy(files[i].getAbsolutePath(), String.valueOf(targetDir.getAbsolutePath()) + "/" + files[i].getName());
            }
            ++i;
        }
    }

    public static void fileAppend(String target, String source) throws IOException {
        Util.fileThing(source, target, true);
    }

    public static void fileAppendString(String target, String source) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(target, true));
        out.write(source);
        out.close();
    }

    public static void fileCopy(String from, String to) throws IOException {
        Util.fileThing(from, to, false);
    }

    private static void fileThing(String from, String to, boolean append) throws IOException {
        int c;
        BufferedReader in = new BufferedReader(new FileReader(from));
        BufferedWriter out = new BufferedWriter(new FileWriter(to, append));
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static String getExceptionText(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(String.valueOf(e.toString()) + "\n" + e.getMessage() + "\n");
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean isInRange(int x, int y, int[] begin, int[] end) {
        if (begin != null && (x < begin[0] || x == begin[0] && y < begin[1])) {
            return false;
        }
        return end == null || x <= end[0] && (x != end[0] || y <= end[1]);
    }

    public static List permsList(List topList) {
        int numSublists = topList.size();
        if (numSublists == 0) {
            return topList;
        }
        ArrayList retList = new ArrayList();
        List firstElements = (List)topList.get(0);
        List tailPerms = Util.permsList(topList.subList(1, numSublists));
        for (Object item : firstElements) {
            if (tailPerms.size() > 0) {
                for (List subPermList : tailPerms) {
                    ArrayList addList = new ArrayList();
                    addList.add(item);
                    addList.addAll(subPermList);
                    retList.add(addList);
                }
                continue;
            }
            ArrayList addList = new ArrayList();
            addList.add(item);
            retList.add(addList);
        }
        return retList;
    }

    public static StringBuffer readFile(File from) throws IOException {
        int c;
        BufferedReader in = new BufferedReader(new FileReader(from));
        StringWriter sWriter = new StringWriter();
        BufferedWriter out = new BufferedWriter(sWriter);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
        return sWriter.getBuffer();
    }

    public static ArrayList split(String s, char divider) {
        ArrayList<String> retList = new ArrayList<String>();
        int last = 0;
        int sLength = s.length();
        int i = 0;
        while (i < sLength) {
            if (s.charAt(i) == divider) {
                retList.add(s.substring(last, i));
                last = i + 1;
            }
            ++i;
        }
        retList.add(s.substring(last, i));
        return retList;
    }

    public static boolean wipeDirectory(File dir, boolean recursive) throws IOException {
        boolean ret = true;
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                if (recursive) {
                    if (!Util.wipeDirectory(files[i], recursive)) {
                        ret = false;
                    }
                    if (!files[i].delete()) {
                        ret = false;
                    }
                }
            } else if (!files[i].delete()) {
                ret = false;
            }
            ++i;
        }
        return ret;
    }
}

