/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.schema;

import com.joanju.DataXferStream;
import com.joanju.Xferable;
import java.io.IOException;
import java.util.Comparator;
import java.util.TreeSet;
import org.prorefactor.core.schema.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
implements Xferable {
    private String name;
    private TreeSet<Table> tableSet = new TreeSet<Table>(Table.NAME_ORDER);
    public static final Comparator<Database> NAME_ORDER = new Comparator<Database>(){

        @Override
        public int compare(Database d1, Database d2) {
            return d1.getName().compareToIgnoreCase(d2.getName());
        }
    };

    public Database() {
    }

    public Database(String name) {
        this.setName(name);
    }

    public void add(Table table) {
        this.tableSet.add(table);
    }

    public String getName() {
        return this.name;
    }

    public TreeSet<Table> getTableSet() {
        return this.tableSet;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void writeXferBytes(DataXferStream out) throws IOException {
        out.writeRef(this.name);
    }

    @Override
    public void writeXferSchema(DataXferStream out) throws IOException {
        out.schemaRef("name");
    }
}

