/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.schema;

import com.joanju.DataXferStream;
import com.joanju.Xferable;
import java.io.IOException;
import java.util.Comparator;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.schema.Schema;
import org.prorefactor.core.schema.Table;
import org.prorefactor.treeparser.ClassSupport;
import org.prorefactor.treeparser.DataType;
import org.prorefactor.treeparser.Primative;

public class Field
implements Primative,
Xferable {
    private int extent;
    String name;
    private DataType dataType;
    private String className = null;
    private Table table;
    static final Comparator<Field> NAME_ORDER = new Comparator<Field>(){

        @Override
        public int compare(Field f1, Field f2) {
            return f1.name.compareToIgnoreCase(f2.name);
        }
    };

    public Field() {
    }

    public Field(String inName, Table table) {
        this.name = inName;
        this.table = table;
        if (table != null) {
            table.add(this);
        }
    }

    Field(String inName) {
        this.name = inName;
        this.table = Schema.nullTable;
    }

    public void assignAttributesLike(Primative likePrim) {
        this.dataType = likePrim.getDataType();
        this.className = likePrim.getClassName();
        this.extent = likePrim.getExtent();
    }

    public Field copyBare(Table toTable) {
        Field f = new Field(this.name, toTable);
        f.dataType = this.dataType;
        f.extent = this.extent;
        f.className = this.className;
        return f;
    }

    public String getClassName() {
        return this.className;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getExtent() {
        return this.extent;
    }

    public String getName() {
        return this.name;
    }

    public Table getTable() {
        return this.table;
    }

    public Primative setClassName(String s) {
        this.className = s;
        return this;
    }

    public Primative setClassName(JPNode typeNameNode) {
        this.className = ClassSupport.qualifiedClassName(typeNameNode);
        return this;
    }

    public Primative setDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public Primative setExtent(int extent) {
        this.extent = extent;
        return this;
    }

    public void setTable(Table table) {
        this.table = table;
        table.add(this);
    }

    public void writeXferBytes(DataXferStream out) throws IOException {
        out.writeRef(this.className);
        out.writeRef(this.dataType);
        out.writeInt(this.extent);
        out.writeRef(this.name);
        out.writeRef(this.table);
    }

    public void writeXferSchema(DataXferStream out) throws IOException {
        out.schemaRef("className");
        out.schemaRef("dataType");
        out.schemaInt("extent");
        out.schemaRef("name");
        out.schemaRef("table");
    }

    public static class Name {
        public String db;
        public String table;
        public String field;

        public Name(String dbPart, String tablePart, String fieldPart) {
            this.db = dbPart;
            this.table = tablePart;
            this.field = fieldPart;
        }

        public Name(String name) {
            String[] parts = name.split("\\.");
            if (parts.length == 1) {
                this.field = parts[0];
            } else if (parts.length == 2) {
                this.table = parts[0];
                this.field = parts[1];
            } else {
                this.db = parts[0];
                this.table = parts[1];
                this.field = parts[2];
            }
        }

        public String generateName() {
            StringBuilder buff = new StringBuilder();
            if (this.table != null && this.table.length() > 0) {
                if (this.db != null && this.db.length() > 0) {
                    buff.append(this.db);
                    buff.append(".");
                }
                buff.append(this.table);
                buff.append(".");
            }
            buff.append(this.field);
            return buff.toString();
        }
    }
}

