/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.schema;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.prorefactor.core.schema.Database;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.Table;
import org.prorefactor.treeparser.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema {
    public static Database nullDatabase = new Database("");
    private static Schema theInstance;
    public static Table nullTable;
    private HashMap<String, String> aliases;
    private TreeSet<Database> dbSet;
    private TreeSet<Table> allTables;
    static final Comparator<Table> ALLTABLES_ORDER;
    static final Comparator IGNORECASE_ORDER;

    static {
        nullTable = new Table("");
        ALLTABLES_ORDER = new Comparator<Table>(){

            @Override
            public int compare(Table s1, Table s2) {
                int ret = s1.getName().compareToIgnoreCase(s2.getName());
                if (ret != 0) {
                    return ret;
                }
                return s1.getDatabase().getName().compareToIgnoreCase(s2.getDatabase().getName());
            }
        };
        IGNORECASE_ORDER = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareToIgnoreCase(s2);
            }
        };
    }

    private Schema() {
        this.initRefresh();
    }

    public TreeSet<Database> getDbSet() {
        return this.dbSet;
    }

    public static Schema getInstance() {
        if (theInstance == null) {
            theInstance = new Schema();
        }
        return theInstance;
    }

    public void clear() {
        this.initRefresh();
    }

    private void initRefresh() {
        this.aliases = new HashMap();
        this.dbSet = new TreeSet<Database>(Database.NAME_ORDER);
        this.allTables = new TreeSet<Table>(ALLTABLES_ORDER);
    }

    public String aliasCreate(String aliasname, String dbname) {
        this.aliases.put(aliasname.toLowerCase(), dbname);
        return "";
    }

    public void aliasDelete(String aliasname) {
        if (aliasname == null || aliasname.length() == 0) {
            this.aliases.clear();
        } else {
            this.aliases.remove(aliasname.toLowerCase());
        }
    }

    public Iterator getAllTablesIterator() {
        return this.allTables.iterator();
    }

    public void loadSchema(String from) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(from));
        StreamTokenizer tokenstream = new StreamTokenizer(reader);
        tokenstream.eolIsSignificant(false);
        tokenstream.wordChars(33, 122);
        Database currDatabase = null;
        Table currTable = null;
        try {
            while (tokenstream.nextToken() != -1) {
                String theString = tokenstream.sval;
                if (theString.equals("::")) {
                    tokenstream.nextToken();
                    String dbname = tokenstream.sval;
                    tokenstream.nextToken();
                    currDatabase = new Database(dbname);
                    this.dbSet.add(currDatabase);
                    continue;
                }
                if (theString.equals(":")) {
                    tokenstream.nextToken();
                    String tablename = tokenstream.sval;
                    tokenstream.nextToken();
                    currTable = new Table(tablename, currDatabase);
                    this.allTables.add(currTable);
                    continue;
                }
                String fieldname = tokenstream.sval;
                tokenstream.nextToken();
                tokenstream.nextToken();
                String typeName = tokenstream.sval;
                Field field = new Field(fieldname, currTable);
                field.setDataType(DataType.getDataType(typeName));
                if (field.getDataType() == null) {
                    throw new IOException("Unknown datatype: " + typeName);
                }
                tokenstream.nextToken();
                field.setExtent((int)tokenstream.nval);
            }
        }
        catch (Throwable e) {
            IOException e2 = new IOException("Schema load failed. Invalid schema file? " + from + "\n" + e.toString());
            e2.initCause(e);
            throw e2;
        }
        reader.close();
    }

    public Database lookupDatabase(String inName) {
        Database db = this.lookupDatabase2(inName);
        if (db != null) {
            return db;
        }
        String realName = this.aliases.get(inName.toLowerCase());
        if (realName == null) {
            return null;
        }
        return this.lookupDatabase2(realName);
    }

    private Database lookupDatabase2(String inName) {
        SortedSet<Database> dbTailSet = this.dbSet.tailSet(new Database(inName));
        if (dbTailSet.size() == 0) {
            return null;
        }
        Database db = dbTailSet.first();
        if (db == null || db.getName().compareToIgnoreCase(inName) != 0) {
            return null;
        }
        return db;
    }

    public Field lookupField(String dbName, String tableName, String fieldName) {
        Table table = this.lookupTable(dbName, tableName);
        if (table == null) {
            return null;
        }
        return table.lookupField(fieldName);
    }

    public Table lookupTable(String inName) {
        if (inName.indexOf(46) > -1) {
            Table firstTry = this.lookupTable2(inName);
            if (firstTry != null) {
                return firstTry;
            }
            return this.lookupMetaTable(inName);
        }
        return this.lookupTableCheckName(this.allTables.tailSet(new Table(inName)), inName);
    }

    public Table lookupTable(String dbName, String tableName) {
        Database db = this.lookupDatabase(dbName);
        if (db == null) {
            return null;
        }
        return this.lookupTableCheckName(db.getTableSet().tailSet(new Table(tableName)), tableName);
    }

    private Table lookupTableCheckName(SortedSet set, String name) {
        Table next;
        String lname = name.toLowerCase();
        Iterator it = set.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Table table = (Table)it.next();
        if (!table.getName().toLowerCase().startsWith(lname)) {
            return null;
        }
        if (lname.length() < table.getName().length() && it.hasNext() && (next = (Table)it.next()).getName().toLowerCase().startsWith(lname)) {
            return null;
        }
        return table;
    }

    private Table lookupTable2(String inName) {
        String[] parts = inName.split("\\.");
        return this.lookupTable(parts[0], parts[1]);
    }

    private Table lookupMetaTable(String inName) {
        String[] parts = inName.split("\\.");
        Database db = this.lookupDatabase("dictdb");
        if (db == null) {
            return null;
        }
        return this.lookupTableCheckName(db.getTableSet().tailSet(new Table(parts[1])), parts[1]);
    }

    public Field lookupUnqualifiedField(String name) {
        for (Table allTable : this.allTables) {
            Table table = allTable;
            Field field = table.lookupField(name);
            if (field == null) continue;
            return field;
        }
        return null;
    }
}

