/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.schema;

import com.joanju.DataXferStream;
import com.joanju.Xferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.prorefactor.core.schema.Database;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.Schema;
import org.prorefactor.treeparser.SymbolScopeRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements Xferable {
    private int storetype = 1102;
    private ArrayList<Field> fieldPosOrder = new ArrayList();
    String name;
    private Database database;
    private TreeSet<Field> fieldSet = new TreeSet<Field>(Field.NAME_ORDER);
    public static final Comparator<Table> NAME_ORDER = new Comparator<Table>(){

        @Override
        public int compare(Table t1, Table t2) {
            return t1.name.compareToIgnoreCase(t2.name);
        }
    };

    public Table() {
    }

    public Table(String name, Database database) {
        this.name = name;
        this.database = database;
        database.add(this);
    }

    public Table(String name, int storetype) {
        this.name = name;
        this.storetype = storetype;
        this.database = Schema.nullDatabase;
    }

    public Table(String name) {
        this.name = name;
        this.database = Schema.nullDatabase;
    }

    void add(Field field) {
        this.fieldSet.add(field);
        this.fieldPosOrder.add(field);
    }

    public Table copyBare(SymbolScopeRoot scope) {
        Table t = scope.lookupTableDefinition(this.name);
        if (t != null) {
            return t;
        }
        t = new Table(this.name, this.storetype);
        for (Field field : this.fieldPosOrder) {
            field.copyBare(t);
        }
        return t;
    }

    public Database getDatabase() {
        return this.database;
    }

    public ArrayList<Field> getFieldPosOrder() {
        return this.fieldPosOrder;
    }

    public TreeSet<Field> getFieldSet() {
        return this.fieldSet;
    }

    public String getName() {
        return this.name;
    }

    public int getStoretype() {
        return this.storetype;
    }

    public Field lookupField(String lookupName) {
        SortedSet<Field> fieldTailSet = this.fieldSet.tailSet(new Field(lookupName));
        if (fieldTailSet.size() == 0) {
            return null;
        }
        Field field = fieldTailSet.first();
        if (field == null || !field.getName().toLowerCase().startsWith(lookupName.toLowerCase())) {
            return null;
        }
        return field;
    }

    @Override
    public void writeXferBytes(DataXferStream out) throws IOException {
        out.writeRef(this.name);
        out.writeRef(this.database);
        out.writeInt(this.storetype);
    }

    @Override
    public void writeXferSchema(DataXferStream out) throws IOException {
        out.schemaRef("name");
        out.schemaRef("database");
        out.schemaInt("storetype");
    }

    public static class Name {
        public String db;
        public String table;

        public Name(String dbPart, String tablePart) {
            this.db = dbPart;
            this.table = tablePart;
        }

        public Name(String name) {
            String[] parts = name.split("\\.");
            if (parts.length == 1) {
                this.table = parts[0];
            } else {
                this.db = parts[0];
                this.table = parts[1];
            }
        }

        public String generateName() {
            StringBuilder buff = new StringBuilder();
            if (this.db != null && this.db.length() > 0) {
                buff.append(this.db);
                buff.append(".");
            }
            buff.append(this.table);
            return buff.toString();
        }
    }
}

