/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.unittest;

import com.joanju.proparse.ProToken;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TreeSet;
import org.prorefactor.core.JPNode;
import org.prorefactor.treeparser.Block;
import org.prorefactor.treeparser.ParseUnit;
import org.prorefactor.treeparser.Symbol;
import org.prorefactor.treeparser.TableBuffer;

public class AttributedWriter {
    BufferedWriter writer = null;

    private String getAttributes(JPNode node) {
        StringBuffer nodeComments = new StringBuffer("");
        this.getAttributesForSymbol(node, nodeComments);
        this.getAttributesForBlock(node, nodeComments);
        if (nodeComments.length() > 0) {
            nodeComments.insert(0, " /*");
            nodeComments.append(" */ ");
            if (node.getType() == 979) {
                nodeComments.append(System.getProperty("line.separator"));
            }
        }
        return nodeComments.toString();
    }

    private void getAttributesForBlock(JPNode node, StringBuffer nodeComments) {
        Block block = (Block)node.getLink(-214);
        if (block == null) {
            return;
        }
        TableBuffer[] buffers = block.getBlockBuffers();
        if (buffers.length == 0) {
            return;
        }
        TreeSet<String> names = new TreeSet<String>();
        TableBuffer[] tableBufferArray = buffers;
        int n = buffers.length;
        int n2 = 0;
        while (n2 < n) {
            TableBuffer buffSymbol = tableBufferArray[n2];
            StringBuffer name = new StringBuffer();
            if (buffSymbol.getTable().getStoretype() == 1102) {
                name.append(buffSymbol.getTable().getDatabase().getName());
                name.append(".");
            }
            name.append(buffSymbol.getName());
            names.add(name.toString());
            ++n2;
        }
        nodeComments.append(" buffers=");
        int i = 0;
        for (String name : names) {
            if (i > 0) {
                nodeComments.append(",");
            }
            nodeComments.append(name);
            ++i;
        }
    }

    private void getAttributesForSymbol(JPNode node, StringBuffer nodeComments) {
        Symbol symbol = (Symbol)node.getLink(-210);
        if (symbol == null) {
            return;
        }
        nodeComments.append(" ");
        nodeComments.append(symbol.getScope().depth());
        nodeComments.append(":");
        nodeComments.append(symbol.fullName());
        if (node.attrGet(1700) > 0) {
            nodeComments.append(" abbrev");
        }
        if (node.attrGet(10150) > 0) {
            nodeComments.append(" unqualfield");
        }
    }

    private void walker(JPNode node, boolean showSiblings) throws IOException {
        if (node == null) {
            return;
        }
        if (node.attrGet(1200) == 1) {
            this.walker(node.firstChild(), false);
            this.writeNode(node);
            this.walker(node.firstChild().nextSibling(), true);
        } else {
            this.writeNode(node);
            this.walker(node.firstChild(), true);
        }
        if (showSiblings) {
            this.walker(node.nextSibling(), true);
        }
    }

    public void write(String inName, String outName) throws Exception {
        try {
            ParseUnit pu = new ParseUnit(new File(inName));
            pu.treeParser01();
            this.writer = new BufferedWriter(new FileWriter(outName));
            this.walker(pu.getTopNode(), true);
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
            }
        }
    }

    private void writeNode(JPNode node) throws IOException {
        ProToken t = node.getHiddenFirst();
        while (t != null) {
            this.writer.write(t.getText());
            t = t.getNext();
        }
        this.writer.write(this.getAttributes(node));
        this.writer.write(node.getText());
    }
}

