/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.unittest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.treeparser.ParseUnit;
import org.prorefactor.treeparserbase.JPTreeParser;

public class ParseAny
extends TestCase {
    File topDir;
    File parseListFile;
    String[] extensions;

    protected void setUp() throws Exception {
        super.setUp();
        this.loadProperties();
    }

    private void loadProperties() throws Exception {
        File propsfile = new File("parseany.properties");
        if (!propsfile.exists()) {
            throw new IOException("The file 'parseany.properties' must be in your working directory.");
        }
        Properties props = new Properties();
        props.load(new FileInputStream(propsfile));
        String projectPropsDirName = props.getProperty("projectPropsDir");
        if (StringUtils.isEmpty((String)projectPropsDirName)) {
            throw new Exception("projectPropsDir must be defined");
        }
        RefactorSession.getInstance().loadProjectPropertiesFromDirectory(projectPropsDirName);
        String listFileProp = props.getProperty("parseListFile");
        if (!StringUtils.isEmpty((String)listFileProp)) {
            this.parseListFile = new File(listFileProp);
            if (!this.parseListFile.exists()) {
                throw new Exception(String.valueOf(listFileProp) + " does not exist");
            }
        } else {
            String extensionsProp = props.getProperty("extensions");
            if (StringUtils.isEmpty((String)extensionsProp)) {
                throw new Exception("extensions must be defined");
            }
            this.extensions = StringUtils.split((String)extensionsProp);
            String topDirProp = props.getProperty("topParseDir");
            if (StringUtils.isEmpty((String)topDirProp)) {
                throw new Exception("topParseDir must be defined");
            }
            this.topDir = new File(topDirProp);
            if (!this.topDir.exists() || !this.topDir.isDirectory()) {
                throw new Exception(String.valueOf(topDirProp) + " is not a directory");
            }
        }
    }

    private void parseOne(File file) throws Exception {
        System.out.println(file.getPath());
        ParseUnit pu = new ParseUnit(file);
        pu.treeParser(new JPTreeParser());
        pu.treeParser01();
    }

    private void parseFromTopDir() throws Exception {
        Collection files = FileUtils.listFiles((File)this.topDir, (String[])this.extensions, (boolean)true);
        for (File file : files) {
            this.parseOne(file);
        }
    }

    private void parseFromList() throws Exception {
        List lines = FileUtils.readLines((File)this.parseListFile);
        for (Object obj : lines) {
            String line = ((String)obj).trim();
            if (StringUtils.isEmpty((String)line)) continue;
            this.parseOne(new File(line));
        }
    }

    public void test01() throws Exception {
        if (this.parseListFile != null) {
            this.parseFromList();
        } else {
            this.parseFromTopDir();
        }
        System.out.println("ParseAny completed OK");
    }
}

