/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.unittest;

import org.prorefactor.core.JPNode;
import org.prorefactor.core.JPNodeLister;
import org.prorefactor.core.TokenTypesI;
import org.prorefactor.nodetypes.BlockNode;
import org.prorefactor.nodetypes.FieldRefNode;
import org.prorefactor.treeparser.Block;
import org.prorefactor.treeparser.FieldContainer;
import org.prorefactor.widgettypes.Frame;

public class TP01FramesTreeLister
extends JPNodeLister {
    public TP01FramesTreeLister(JPNode topNode, String outfilename, TokenTypesI typesReader) {
        super(topNode, outfilename, typesReader);
    }

    private void appendName(StringBuffer buff, FieldContainer container) {
        if (container.getName().length() == 0) {
            buff.append('\"').append(container.getName()).append('\"');
        } else {
            buff.append(container.getName());
        }
    }

    protected String generateLineText(JPNode node) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.indent()).append(this.tokenTypes.getName(node.getType())).append('|').append(node.getText()).append('|');
        if (node instanceof BlockNode) {
            this.blockNode(buff, (BlockNode)node);
        }
        if (node instanceof FieldRefNode) {
            this.fieldRefNode(buff, (FieldRefNode)node);
            this.fieldContainer(buff, node);
        }
        if (node.isStateHead()) {
            this.fieldContainer(buff, node);
        }
        return buff.toString();
    }

    private void blockNode(StringBuffer buff, BlockNode blockNode) {
        Block block = blockNode.getBlock();
        if (block.getDefaultFrame() != null) {
            buff.append(this.spacer).append("defaultFrame:");
            this.appendName(buff, block.getDefaultFrame());
        }
        buff.append(this.spacer).append("frames:");
        for (Frame frame : block.getFrames()) {
            buff.append(" ");
            this.appendName(buff, frame);
        }
    }

    private void fieldContainer(StringBuffer buff, JPNode node) {
        FieldContainer fieldContainer = node.getFieldContainer();
        if (fieldContainer == null) {
            return;
        }
        buff.append(this.spacer).append(this.tokenTypes.getName(fieldContainer.getProgressType())).append("=");
        this.appendName(buff, fieldContainer);
    }

    private void fieldRefNode(StringBuffer buff, FieldRefNode refNode) {
        buff.append(this.spacer).append(refNode.getSymbol().fullName());
    }
}

