/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.unittest;

import java.io.File;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.prorefactor.core.unittest.RoutineHandler;
import org.prorefactor.treeparser.Call;
import org.prorefactor.treeparser.ParseUnit;
import org.prorefactor.treeparser01.TP01Support;

public class TP01ProcessActionTest
extends TestCase {
    private TP01Support symbolAction;

    public TP01ProcessActionTest(String name) {
        super(name);
    }

    public void setUp() {
        this.symbolAction = new TP01Support();
    }

    public void testCompileFileCalls() throws Exception {
        File file = new File("data/tp01ProcessTests/compile-file.p");
        String externalName = file.getPath();
        ParseUnit pu = new ParseUnit(file);
        pu.treeParser01(this.symbolAction);
        RoutineHandler enableUi = new RoutineHandler("enable-ui", this.symbolAction);
        RoutineHandler userAction = new RoutineHandler("user-action", this.symbolAction);
        RoutineHandler disableUi = new RoutineHandler("disable-ui", this.symbolAction);
        RoutineHandler setState = new RoutineHandler("setState", this.symbolAction);
        RoutineHandler getCompileList = new RoutineHandler("get-compile-list", this.symbolAction);
        Call enableUiCall = new Call(externalName, enableUi.getName());
        Call userActionCall = new Call(externalName, userAction.getName());
        Call disableUiCall = new Call(externalName, disableUi.getName());
        Call setStateCall = new Call(externalName, setState.getName());
        Call getCompileListCall = new Call(externalName, getCompileList.getName());
        ArrayList<Call> expectedRootCalls = new ArrayList<Call>();
        expectedRootCalls.add(disableUiCall);
        expectedRootCalls.add(enableUiCall);
        expectedRootCalls.add(userActionCall);
        ArrayList<Call> actualRootCalls = pu.getRootScope().getCallList();
        TP01ProcessActionTest.assertTrue((boolean)actualRootCalls.containsAll(expectedRootCalls));
        TP01ProcessActionTest.assertTrue((!actualRootCalls.contains(setStateCall) ? 1 : 0) != 0);
        TP01ProcessActionTest.assertTrue((!actualRootCalls.contains(getCompileListCall) ? 1 : 0) != 0);
        ArrayList<Call> actualEnableUiCalls = enableUi.getRoutineScope().getCallList();
        TP01ProcessActionTest.assertTrue((boolean)actualEnableUiCalls.contains(setStateCall));
        ArrayList<Call> actualUserActionCalls = userAction.getRoutineScope().getCallList();
        TP01ProcessActionTest.assertTrue((boolean)actualUserActionCalls.contains(getCompileListCall));
        ArrayList<Call> actualGetCompileListCalls = getCompileList.getRoutineScope().getCallList();
        TP01ProcessActionTest.assertTrue((boolean)actualGetCompileListCalls.contains(setStateCall));
    }

    public void testPersistenProc() throws Exception {
        File file = new File("data/tp01ProcessTests/persistent-run.p");
        String externalName = file.getPath();
        ParseUnit pu = new ParseUnit(file);
        pu.treeParser01(this.symbolAction);
        TP01ProcessActionTest.assertTrue((this.symbolAction.getErrorList().size() == 0 ? 1 : 0) != 0);
        RoutineHandler test01 = new RoutineHandler("test_01", this.symbolAction);
        RoutineHandler test02 = new RoutineHandler("test_02", this.symbolAction);
        String targetProc = "persistent-proc.p";
        Call persistentProcCall = new Call(targetProc, null);
        Call test01InHandleCall = new Call(targetProc, test01.getName());
        Call test02InHandleCall = new Call(targetProc, test02.getName());
        Call test01InternalCall = new Call(externalName, test01.getName());
        ArrayList<Call> expectedRootCalls = new ArrayList<Call>();
        expectedRootCalls.add(persistentProcCall);
        expectedRootCalls.add(test01InHandleCall);
        expectedRootCalls.add(test01InternalCall);
        ArrayList<Call> expectedTest01Calls = new ArrayList<Call>();
        expectedTest01Calls.add(test02InHandleCall);
        ArrayList<Call> actualRootCalls = pu.getRootScope().getCallList();
        TP01ProcessActionTest.assertTrue((boolean)actualRootCalls.containsAll(expectedRootCalls));
        TP01ProcessActionTest.assertTrue((!actualRootCalls.contains(test02InHandleCall) ? 1 : 0) != 0);
        ArrayList<Call> actualTest01Calls = test01.getRoutineScope().getCallList();
        TP01ProcessActionTest.assertTrue((boolean)actualTest01Calls.containsAll(expectedTest01Calls));
    }
}

