/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.unittest;

import java.io.File;
import junit.framework.TestCase;
import org.prorefactor.core.unittest.RoutineHandler;
import org.prorefactor.treeparser.ParseUnit;
import org.prorefactor.treeparser.SymbolScope;
import org.prorefactor.treeparser01.TP01Support;
import org.prorefactor.treeparser01.TreeParser01;

public class TP01SymbolActionTest
extends TestCase {
    private TP01Support walkAction;
    private TreeParser01 walker;

    public void setUp() {
        this.walkAction = new TP01Support();
        this.walker = new TreeParser01();
        this.walker.setActionObject(this.walkAction);
    }

    public void testCompileFileRoutines() throws Exception {
        ParseUnit pu = new ParseUnit(new File("data/tp01ProcessTests/compile-file.p"));
        pu.treeParser(this.walker);
        RoutineHandler enableUi = new RoutineHandler("enable-ui", this.walkAction);
        RoutineHandler userAction = new RoutineHandler("user-action", this.walkAction);
        RoutineHandler disableUi = new RoutineHandler("disable-ui", this.walkAction);
        RoutineHandler setState = new RoutineHandler("setState", this.walkAction);
        RoutineHandler getCompileList = new RoutineHandler("get-compile-list", this.walkAction);
        TP01SymbolActionTest.assertTrue((boolean)this.rootScope().hasRoutine(enableUi.getName()));
        TP01SymbolActionTest.assertTrue((boolean)this.rootScope().hasRoutine(userAction.getName()));
        TP01SymbolActionTest.assertTrue((boolean)this.rootScope().hasRoutine(disableUi.getName()));
        TP01SymbolActionTest.assertTrue((boolean)this.rootScope().hasRoutine(setState.getName()));
        TP01SymbolActionTest.assertTrue((boolean)this.rootScope().hasRoutine(getCompileList.getName()));
    }

    public void testCompileFileVars() throws Exception {
        ParseUnit pu = new ParseUnit(new File("data/tp01ProcessTests/compile-file.p"));
        pu.treeParser(this.walker);
        String sourcePath = "sourcePath";
        String currentPropath = "currentPropath";
        String compileFile = "compileFile";
        String currentStatus = "currentStatus";
        String test = "test";
        String aFile = "aFile";
        String aNewFile = "aNewFile";
        String aNewSrcDir = "aNewSrcDir";
        RoutineHandler getCompileList = new RoutineHandler("get-compile-list", this.walkAction);
        TP01SymbolActionTest.assertTrue((this.rootScope().lookupVariable(sourcePath) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((this.rootScope().lookupVariable(currentPropath) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((this.rootScope().lookupVariable(compileFile) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((this.rootScope().lookupVariable(currentStatus) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((this.rootScope().lookupVariable(test) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((this.rootScope().lookupVariable(aFile) == null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((this.rootScope().lookupVariable(aNewFile) == null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((this.rootScope().lookupVariable(aNewSrcDir) == null ? 1 : 0) != 0);
        SymbolScope routineScope = getCompileList.getRoutineScope();
        TP01SymbolActionTest.assertTrue((routineScope.lookupVariable(aFile) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((routineScope.lookupVariable(aNewFile) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((routineScope.lookupVariable(aNewSrcDir) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((routineScope.lookupVariable(sourcePath) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((routineScope.lookupVariable(currentPropath) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((routineScope.lookupVariable(compileFile) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((routineScope.lookupVariable(currentStatus) != null ? 1 : 0) != 0);
        TP01SymbolActionTest.assertTrue((routineScope.lookupVariable(test) != null ? 1 : 0) != 0);
    }

    private SymbolScope rootScope() {
        return this.walkAction.getRootScope();
    }
}

