/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.unittest;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import junit.textui.TestRunner;
import org.apache.commons.io.FileUtils;
import org.prorefactor.core.Util;
import org.prorefactor.core.schema.Schema;
import org.prorefactor.core.unittest.AttributedWriter;
import org.prorefactor.core.unittest.TP01Test01;
import org.prorefactor.core.unittest.UnitTestBase2;

public class TP01Test02
extends UnitTestBase2 {
    File outFile;
    File snippetFile;
    String expectName = "data/tp01tests/test02.expect.txt";
    String inName = "data/tp01tests/test02.in.txt";
    String outName = "data/tp01tests/test02.out.txt";
    String schemaName = "data/sports2000.schema";
    String snippetName = "data/tempsnippet.p";
    String snippetOutName = "data/tempout.p";
    String snippetSep = "--------------------------------" + System.getProperty("line.separator");

    public TP01Test02(String arg0) {
        super(arg0);
        this.outFile = new File(this.outName);
        this.snippetFile = new File(this.snippetName);
    }

    public static void main(String[] args) {
        TestRunner.run(TP01Test01.class);
    }

    public void test01() throws Exception {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            Schema schema = Schema.getInstance();
            schema.clear();
            schema.loadSchema(this.schemaName);
            this.outFile.delete();
            reader = new BufferedReader(new FileReader(this.inName));
            String line = null;
            do {
                writer = new BufferedWriter(new FileWriter(this.snippetFile));
                while ((line = reader.readLine()) != null && !line.startsWith("--")) {
                    writer.write(line);
                    writer.newLine();
                }
                writer.close();
                AttributedWriter attWriter = new AttributedWriter();
                attWriter.write(this.snippetName, this.snippetOutName);
                Util.fileAppend(this.outName, this.snippetOutName);
                Util.fileAppendString(this.outName, this.snippetSep);
            } while (line != null);
            this.snippetFile.delete();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        TP01Test02.assertTrue((boolean)FileUtils.contentEquals((File)new File(this.expectName), (File)new File(this.outName)));
    }
}

