/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.unittest;

import java.io.File;
import java.io.FileFilter;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.prorefactor.core.ICallback;

public class UnitTestBase2
extends TestCase {
    public FileFilter testCompareDirectoriesFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                if (pathname.getName().equals("CVS")) {
                    return false;
                }
                if (pathname.getName().equals(".svn")) {
                    return false;
                }
            }
            return true;
        }
    };

    public UnitTestBase2(String s) {
        super(s);
    }

    public String testCompareDirectories(File dir1, File dir2) {
        String ret = this.testCompareDirectories2(dir1, dir2, null);
        if (ret != null) {
            return ret;
        }
        return this.testCompareDirectories2(dir2, dir1, null);
    }

    public String testCompareDirectories2(File dir1, File dir2, ICallback fileTest) {
        if (!dir1.exists() || !dir1.isDirectory()) {
            return String.valueOf(dir1.toString()) + " does not exist or is not a directory.";
        }
        if (!dir2.exists() || !dir2.isDirectory()) {
            return String.valueOf(dir2.toString()) + " does not exist or is not a directory.";
        }
        File[] files1 = dir1.listFiles(this.testCompareDirectoriesFilter);
        File[] files2 = dir2.listFiles(this.testCompareDirectoriesFilter);
        int i = 0;
        while (i < files2.length) {
            String ret;
            if (i + 1 > files1.length || !files2[i].getName().equals(files1[i].getName())) {
                return String.valueOf(files1[i].toString()) + ": File list difference: " + files2[i].toString();
            }
            if (files2[i].isDirectory()) {
                ret = this.testCompareDirectories2(files1[i], files2[i], fileTest);
                if (ret != null) {
                    return ret;
                }
            } else {
                if (!files1[i].isFile()) {
                    return String.valueOf(files1[i].toString()) + " is not a file";
                }
                if (fileTest != null && (ret = (String)fileTest.run(new Object[]{files1[i], files2[i]})) != null) {
                    return ret;
                }
            }
            ++i;
        }
        return null;
    }

    public String testCompareFiles(File dir1, File dir2) {
        ICallback callback = new ICallback(){

            public Object run(Object obj) {
                Object[] files = (Object[])obj;
                File first = (File)files[0];
                File second = (File)files[1];
                return UnitTestBase2.this.testCompareSingle(first, second);
            }
        };
        String ret = this.testCompareDirectories2(dir1, dir2, null);
        if (ret != null) {
            return ret;
        }
        return this.testCompareDirectories2(dir2, dir1, callback);
    }

    public String testCompareSingle(File first, File second) {
        boolean equal;
        try {
            equal = FileUtils.contentEquals((File)first, (File)second);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        if (!equal) {
            return "Files are different: " + first.toString() + " " + second.toString();
        }
        return null;
    }
}

