/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.io;

import java.io.IOException;
import java.io.PrintStream;
import org.prorefactor.core.Util;
import org.prorefactor.io.LogFile;

public class LogWriter {
    LogFile errorLog = LogFile.createErrorLog();
    LogFile exceptionLog = LogFile.createExceptionLog();
    LogFile statusLog = LogFile.createOutputLog();
    PrintStream printStream = null;

    public LogWriter(PrintStream printStream) throws IOException {
        this.printStream = printStream;
    }

    public void close() throws IOException {
        this.errorLog.close();
        this.exceptionLog.close();
        this.statusLog.close();
    }

    public void log(String logText) throws IOException {
        if (this.printStream != null) {
            this.printStream.println(logText);
        }
        this.statusLog.write(logText);
        this.statusLog.newLine();
    }

    public void logError(String errorLogPrefix, String errorText) throws IOException {
        if (errorLogPrefix != null) {
            this.errorLog.write(errorLogPrefix);
            this.errorLog.newLine();
        }
        this.log(errorText);
        this.errorLog.write(errorText);
        this.errorLog.newLine();
    }

    public void logException(String logPrefix, Exception exception) throws IOException {
        String message;
        if (logPrefix != null) {
            this.exceptionLog.write(logPrefix);
            this.exceptionLog.newLine();
        }
        if ((message = exception.getMessage()) == null) {
            message = exception.toString();
        }
        this.logError(logPrefix, message);
        this.exceptionLog.write(Util.getExceptionText(exception));
        this.exceptionLog.newLine();
    }
}

