/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.macrolevel;

import com.joanju.DataXferStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.prorefactor.macrolevel.MacroDef;
import org.prorefactor.macrolevel.MacroRef;

public class IncludeRef
extends MacroRef {
    public boolean usesNamedArgs;
    public int fileIndex;
    private ArrayList<MacroDef> includeArgs = new ArrayList();
    private HashMap<String, MacroDef> argMap = new HashMap();
    private String fileRefName = "";
    private static final long serialVersionUID = 6085433112733922276L;

    public IncludeRef() {
    }

    IncludeRef(int listingFileLine) {
        super(listingFileLine);
    }

    public void addNamedArg(MacroDef arg) {
        this.includeArgs.add(arg);
        this.argMap.put(arg.name.toLowerCase(), arg);
    }

    public void addNumberedArg(MacroDef arg) {
        this.includeArgs.add(arg);
    }

    public MacroDef getArgNumber(int num) {
        if (num > 0 && num <= this.includeArgs.size()) {
            return this.includeArgs.get(num - 1);
        }
        return null;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public String getFileRefName() {
        return this.fileRefName;
    }

    public MacroDef lookupNamedArg(String name) {
        if (!this.usesNamedArgs) {
            return null;
        }
        return this.argMap.get(name.toLowerCase());
    }

    public int numArgs() {
        return this.includeArgs.size();
    }

    public void setFileRefName(String fileRefName) {
        this.fileRefName = fileRefName;
    }

    public MacroDef undefine(String name) {
        MacroDef theArg = this.argMap.get(name);
        if (theArg != null) {
            this.argMap.remove(name);
            this.argMap.put("", theArg);
            return theArg;
        }
        return null;
    }

    public void writeXferBytes(DataXferStream out) throws IOException {
        super.writeXferBytes(out);
        out.writeRef(this.argMap);
        out.writeInt(this.fileIndex);
        out.writeRef(this.fileRefName);
        out.writeRef(this.includeArgs);
        out.writeBool(this.usesNamedArgs);
    }

    public void writeXferSchema(DataXferStream out) throws IOException {
        super.writeXferSchema(out);
        out.schemaRef("argMap");
        out.schemaInt("fileIndex");
        out.schemaRef("fileRefName");
        out.schemaRef("includeArgs");
        out.schemaBool("usesNamedArgs");
    }
}

