/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.macrolevel;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.prorefactor.macrolevel.IncludeRef;
import org.prorefactor.macrolevel.MacroDef;
import org.prorefactor.macrolevel.MacroLevel;
import org.prorefactor.macrolevel.MacroRef;
import org.prorefactor.macrolevel.NamedMacroRef;
import org.prorefactor.refactor.RefactorException;

public class ListingParser {
    public HashMap<Integer, String> fileIndexes = new HashMap();
    private IncludeRef root = null;
    private int column;
    private int line;
    private int listingFileLine = 0;
    private LinkedList<Scope> scopeStack = new LinkedList();
    private IncludeRef currInclude;
    private HashMap<String, MacroDef> globalDefMap = new HashMap();
    private MacroRef currRef;
    private String listingFile;

    public ListingParser(String listingFile) {
        this.listingFile = listingFile;
    }

    private void ampdef(String[] parts, int type) {
        MacroDef newDef = new MacroDef();
        this.getPosition(parts);
        newDef.parent = this.currRef;
        newDef.line = this.line;
        newDef.column = this.column;
        newDef.name = parts[4];
        newDef.value = this.replaceEscapes(parts[5]);
        newDef.type = type;
        if (type == 1) {
            this.globalDefMap.put(newDef.name, newDef);
        }
        if (type == 2) {
            Scope currScope = this.scopeStack.getFirst();
            currScope.defMap.put(newDef.name, newDef);
        }
        this.currRef.macroEventList.add(newDef);
    }

    private void ampelse(String[] parts) {
    }

    private void ampelseif(String[] parts) {
    }

    private void ampendif(String[] parts) {
    }

    private void ampif(String[] parts) {
    }

    private void createRootNode() {
        this.root = new IncludeRef(this.listingFileLine);
        this.currRef = this.root;
        this.currInclude = this.root;
        this.scopeStack.addFirst(new Scope(this.root));
    }

    private void fileindex(String[] parts) {
        this.fileIndexes.put(new Integer(Integer.parseInt(parts[4])), parts[5]);
    }

    private MacroDef findMacroDef(String name) {
        Scope currScope = this.scopeStack.getFirst();
        MacroDef ret = currScope.defMap.get(name);
        if (ret != null) {
            return ret;
        }
        ret = this.currInclude.lookupNamedArg(name);
        if (ret != null) {
            return ret;
        }
        Iterator it = this.scopeStack.iterator();
        it.next();
        while (it.hasNext()) {
            currScope = (Scope)it.next();
            ret = currScope.defMap.get(name);
            if (ret == null) continue;
            return ret;
        }
        ret = this.globalDefMap.get(name);
        return ret;
    }

    private void getPosition(String[] parts) {
        this.line = Integer.parseInt(parts[1]);
        this.column = Integer.parseInt(parts[2]);
    }

    public IncludeRef getRoot() {
        return this.root;
    }

    private void globdef(String[] parts) {
        this.ampdef(parts, 1);
    }

    private void incarg(String[] parts) {
        MacroDef newArg = new MacroDef();
        newArg.value = this.replaceEscapes(parts[5]);
        newArg.includeRef = this.currInclude;
        newArg.parent = this.currInclude.parent;
        int argNum = 0;
        try {
            argNum = Integer.parseInt(parts[4]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (argNum == 0 || argNum != this.currInclude.numArgs() + 1) {
            newArg.name = parts[4];
            this.currInclude.usesNamedArgs = true;
            newArg.type = 4;
            this.currInclude.addNamedArg(newArg);
        } else {
            newArg.type = 5;
            this.currInclude.addNumberedArg(newArg);
        }
    }

    private void incend(String[] parts) {
        this.scopeStack.removeFirst();
        this.currInclude = this.scopeStack.getFirst().includeRef;
        this.currRef = this.currRef.parent;
    }

    private void include(String[] parts) {
        IncludeRef newRef = new IncludeRef(this.listingFileLine);
        this.scopeStack.addFirst(new Scope(newRef));
        this.currRef.macroEventList.add(newRef);
        newRef.parent = this.currRef;
        this.currInclude = newRef;
        this.currRef = newRef;
        this.getPosition(parts);
        newRef.refLine = this.line;
        newRef.refColumn = this.column;
        newRef.fileIndex = Integer.parseInt(parts[4]);
        if (parts.length > 5) {
            newRef.setFileRefName(parts[5]);
        }
    }

    private void macroref(String[] parts) {
        NamedMacroRef newRef = new NamedMacroRef(this.listingFileLine);
        this.currRef.macroEventList.add(newRef);
        newRef.parent = this.currRef;
        this.currRef = newRef;
        this.getPosition(parts);
        newRef.refLine = this.line;
        newRef.refColumn = this.column;
        newRef.macroDef = this.findMacroDef(parts[4]);
    }

    private void macrorefend(String[] parts) {
        this.currRef = this.currRef.parent;
    }

    public static void main(String[] args) {
        ListingParser listingParser = new ListingParser("tmp/temp.txt");
        try {
            listingParser.parse();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        System.out.println("Done");
    }

    public void parse() throws IOException, RefactorException {
        String currLine;
        FileReader fileReader = new FileReader(this.listingFile);
        BufferedReader reader = new BufferedReader(fileReader);
        this.createRootNode();
        while ((currLine = reader.readLine()) != null) {
            ++this.listingFileLine;
            String[] parts = currLine.split("\\s", 6);
            String token = parts[3].intern();
            if (token == "globdef") {
                this.globdef(parts);
                continue;
            }
            if (token == "scopdef") {
                this.scopdef(parts);
                continue;
            }
            if (token == "macroref") {
                this.macroref(parts);
                continue;
            }
            if (token == "macrorefend") {
                this.macrorefend(parts);
                continue;
            }
            if (token == "undef") {
                this.undef(parts);
                continue;
            }
            if (token == "include") {
                this.include(parts);
                continue;
            }
            if (token == "incarg") {
                this.incarg(parts);
                continue;
            }
            if (token == "incend") {
                this.incend(parts);
                continue;
            }
            if (token == "ampif") {
                this.ampif(parts);
                continue;
            }
            if (token == "ampelseif") {
                this.ampelseif(parts);
                continue;
            }
            if (token == "ampelse") {
                this.ampelse(parts);
                continue;
            }
            if (token == "ampendif") {
                this.ampendif(parts);
                continue;
            }
            if (token == "fileindex") {
                this.fileindex(parts);
                continue;
            }
            if (currLine.trim().length() == 0) continue;
            throw new RefactorException("Invalid token in Proparse listing file. Token: " + token + " Line: " + new Integer(this.listingFileLine).toString());
        }
        reader.close();
        fileReader.close();
    }

    private String replaceEscapes(String s) {
        StringBuilder r = new StringBuilder("");
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c != '\\' || i == len - 1) {
                r.append(c);
            } else {
                char c2 = s.charAt(i + 1);
                switch (c2) {
                    case '\\': {
                        r.append('\\');
                        ++i;
                        break;
                    }
                    case 'n': {
                        r.append('\n');
                        ++i;
                        break;
                    }
                    case 'r': {
                        r.append('\r');
                        ++i;
                        break;
                    }
                    default: {
                        r.append(c);
                    }
                }
            }
            ++i;
        }
        return r.toString();
    }

    private void scopdef(String[] parts) {
        this.ampdef(parts, 2);
    }

    public MacroRef[] sourceArray() {
        return MacroLevel.sourceArray(this.root);
    }

    private void undef(String[] parts) {
        String name = parts[4];
        MacroDef newDef = new MacroDef();
        this.currRef.macroEventList.add(newDef);
        this.getPosition(parts);
        newDef.parent = this.currRef;
        newDef.line = this.line;
        newDef.column = this.column;
        newDef.name = name;
        newDef.type = 3;
        Scope currScope = this.scopeStack.getFirst();
        if (currScope.defMap.containsKey(name)) {
            newDef.undefWhat = currScope.defMap.remove(name);
            return;
        }
        newDef.undefWhat = this.currInclude.undefine(name);
        if (newDef.undefWhat != null) {
            return;
        }
        Iterator it = this.scopeStack.iterator();
        it.next();
        while (it.hasNext()) {
            currScope = (Scope)it.next();
            if (!currScope.defMap.containsKey(name)) continue;
            newDef.undefWhat = currScope.defMap.remove(name);
            return;
        }
        if (this.globalDefMap.containsKey(name)) {
            newDef.undefWhat = this.globalDefMap.remove(name);
        }
    }

    private class Scope {
        HashMap<String, MacroDef> defMap = new HashMap();
        IncludeRef includeRef;

        public Scope(IncludeRef ref) {
            this.includeRef = ref;
        }
    }
}

