/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.macrolevel;

import com.joanju.DataXferStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.prorefactor.core.Util;
import org.prorefactor.macrolevel.IncludeRef;
import org.prorefactor.macrolevel.MacroDef;
import org.prorefactor.macrolevel.MacroEvent;
import org.prorefactor.macrolevel.NamedMacroRef;
import org.prorefactor.refactor.RefactorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MacroRef
implements MacroEvent {
    int listingFileLine;
    public int refColumn;
    public int refLine;
    public MacroRef parent = null;
    public ArrayList<MacroEvent> macroEventList = new ArrayList();

    protected MacroRef() {
    }

    MacroRef(int listingFileLine) {
        this.listingFileLine = listingFileLine;
    }

    public int getListingFileLine() {
        return this.listingFileLine;
    }

    @Override
    public MacroRef getParent() {
        return this.parent;
    }

    public ArrayList<MacroEvent> findExternalMacroReferences() {
        ArrayList<MacroEvent> ret = new ArrayList<MacroEvent>();
        Iterator<MacroEvent> it = this.macroEventList.iterator();
        while (it.hasNext()) {
            this.findExternalMacroReferences(it.next(), ret);
        }
        return ret;
    }

    public ArrayList<MacroEvent> findExternalMacroReferences(int[] begin, int[] end) {
        ArrayList<MacroEvent> ret = new ArrayList<MacroEvent>();
        for (MacroEvent next : this.macroEventList) {
            if (next instanceof MacroRef) {
                MacroRef ref = (MacroRef)next;
                if (!Util.isInRange(ref.refLine, ref.refColumn, begin, end)) continue;
                this.findExternalMacroReferences(ref, ret);
                continue;
            }
            if (!(next instanceof MacroDef)) continue;
            MacroDef def = (MacroDef)next;
            if (!Util.isInRange(def.line, def.column, begin, end)) continue;
            this.findExternalMacroReferences(def, ret);
        }
        return ret;
    }

    private void findExternalMacroReferences(MacroEvent obj, ArrayList<MacroEvent> list) {
        if (obj == null) {
            return;
        }
        if (obj instanceof IncludeRef) {
            list.add(obj);
            return;
        }
        if (obj instanceof MacroDef) {
            MacroDef def = (MacroDef)obj;
            if (def.type == 3) {
                if (def.undefWhat.type == 4) {
                    list.add(def);
                    return;
                }
                if (!this.isMine(def.undefWhat.parent)) {
                    list.add(def);
                }
            }
            return;
        }
        if (!(obj instanceof NamedMacroRef)) {
            return;
        }
        NamedMacroRef ref = (NamedMacroRef)obj;
        if (!this.isMine(ref)) {
            list.add(ref);
            return;
        }
        Iterator it = ref.macroEventList.iterator();
        while (it.hasNext()) {
            this.findExternalMacroReferences((MacroEvent)it.next(), list);
        }
    }

    public ArrayList<IncludeRef> findIncludeReferences(int fileIndex) {
        ArrayList<IncludeRef> ret = new ArrayList<IncludeRef>();
        this.findIncludeReferences(fileIndex, this, ret);
        return ret;
    }

    private void findIncludeReferences(int fileIndex, MacroRef ref, ArrayList<IncludeRef> list) {
        if (ref == null) {
            return;
        }
        if (ref instanceof IncludeRef) {
            IncludeRef incl = (IncludeRef)ref;
            if (incl.fileIndex == fileIndex) {
                list.add(incl);
            }
        }
        for (MacroEvent next : ref.macroEventList) {
            if (!(next instanceof MacroRef)) continue;
            this.findIncludeReferences(fileIndex, (MacroRef)next, list);
        }
    }

    public abstract int getFileIndex();

    @Override
    public int[] getPosition() throws RefactorException {
        int[] ret = new int[]{this.parent.getFileIndex(), this.refLine, this.refColumn};
        return ret;
    }

    private boolean isMine(MacroEvent obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.isMine(obj.getParent());
    }

    @Override
    public void writeXferBytes(DataXferStream out) throws IOException {
        out.writeInt(this.listingFileLine);
        out.writeRef(this.macroEventList);
        out.writeRef(this.parent);
        out.writeInt(this.refColumn);
        out.writeInt(this.refLine);
    }

    @Override
    public void writeXferSchema(DataXferStream out) throws IOException {
        out.schemaInt("listingFileLine");
        out.schemaRef("macroEventList");
        out.schemaRef("parent");
        out.schemaInt("refColumn");
        out.schemaInt("refLine");
    }
}

