/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.refactor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.refactor.messages.Message;

public class FileStuff {
    static RefactorSession prsession = RefactorSession.getInstance();
    public static final String LINESEP = System.getProperty("line.separator");

    public static int countLines(File file) throws IOException {
        BufferedReader buff = new BufferedReader(new FileReader(file));
        int numLines = 0;
        while (buff.readLine() != null) {
            ++numLines;
        }
        buff.close();
        return numLines;
    }

    public static File findFile(String filename) {
        String[] parts;
        File inFile = new File(filename);
        char c = filename.charAt(0);
        if (inFile.isAbsolute() || c == '.' || c == '/' || c == '\\') {
            if (inFile.exists()) {
                return inFile;
            }
            return null;
        }
        String propath = FileStuff.prsession.getProgressSettings().propath;
        String[] stringArray = parts = propath.split(",");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            File retFile = new File(String.valueOf(part) + File.separator + filename);
            if (retFile.exists()) {
                return retFile;
            }
            ++n2;
        }
        return null;
    }

    public static File findFileForClassName(String className) {
        return FileStuff.findFile(String.valueOf(className.replace('.', '/')) + ".cls");
    }

    public static String fullpath(File file) {
        String ret;
        try {
            ret = file.getCanonicalPath();
        }
        catch (IOException e) {
            ret = file.toString();
        }
        return ret;
    }

    public static String insertBeforeExtension(String origName, String insert) {
        int dotpos = origName.lastIndexOf(46);
        return String.valueOf(origName.substring(0, dotpos)) + insert + origName.substring(dotpos);
    }

    public static String prepareTarget(String outputDir, String sourceFilename) {
        File sourceFile = new File(sourceFilename);
        String sourcePath = sourceFile.getAbsolutePath();
        File theTarget = new File(String.valueOf(outputDir) + "/" + sourcePath.replace(':', '_'));
        String returnName = theTarget.getAbsolutePath();
        theTarget = theTarget.getParentFile();
        theTarget.mkdirs();
        return returnName;
    }

    public static ArrayList searchFile(File file, String searchString, String messageString) throws IOException {
        String currline;
        BufferedReader buff = new BufferedReader(new FileReader(file));
        ArrayList<Message> results = new ArrayList<Message>();
        String lowerSearch = searchString.toLowerCase();
        int lineNum = 0;
        while ((currline = buff.readLine()) != null) {
            ++lineNum;
            int lastPos = 0;
            lastPos = currline.toLowerCase().indexOf(lowerSearch, lastPos);
            while (lastPos != -1) {
                Message mess = new Message();
                mess.column = lastPos + 1;
                mess.line = lineNum;
                mess.file = file;
                mess.message = messageString;
                results.add(mess);
                lastPos = currline.indexOf(searchString, lastPos + 1);
            }
        }
        buff.close();
        return results;
    }
}

