/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.refactor;

import antlr.collections.AST;
import com.joanju.proparse.IntegerIndex;
import com.joanju.proparse.NodeFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.TokenTypes;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.Table;
import org.prorefactor.nodetypes.ProgramRootNode;
import org.prorefactor.nodetypes.ProparseDirectiveNode;
import org.prorefactor.refactor.FileStuff;
import org.prorefactor.refactor.RefactorException;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.treeparser.FieldBuffer;
import org.prorefactor.treeparser.ParseUnit;
import org.prorefactor.treeparser.Primative;
import org.prorefactor.treeparser.Symbol;
import org.prorefactor.treeparser.SymbolScopeRoot;
import org.prorefactor.treeparser.SymbolScopeSuper;
import org.prorefactor.treeparser.TableBuffer;
import org.prorefactor.treeparser01.TP01Support;

public class PUB {
    public static final int LAYOUT_VERSION = 11;
    public static final int PUBFILE_TIMESTAMP = 5;
    public static final int FILES = 10;
    public static final int HEADER = 15;
    public static final int SCHEMA = 20;
    public static final int IMPORTS = 30;
    public static final int EXPORTS = 40;
    public static final int AST = 50;
    public static final int STRINGS = 60;
    public static final int END = 100;
    private static final int NODETEXT = 49001;
    private static final int NODECOMMENTS = 49002;
    private boolean checked = false;
    private boolean current = false;
    private boolean usingNonlocalInputBlob = false;
    private int nodeCount;
    private ArrayList<SymbolRef> exportList;
    private ArrayList<String> fileList;
    private ArrayList<SymbolRef> importList;
    private DualHashBidiMap stringTable;
    private File cuFile;
    private File pubFile;
    private DataInputStream inStream;
    private IntegerIndex<String> fileIndexes;
    private ProgramRootNode tree;
    private ParseUnit parseUnit;
    private String unitClassName;
    private String superClassName;
    private String[] stringArray;
    private TreeMap<String, TableRef> tableMap;

    public PUB(String fullPath) {
        this.cuFile = new File(fullPath);
        this.pubFile = new File(String.valueOf(PUB.pubDirFileName(fullPath)) + ".pub");
    }

    private void _refresh() {
        this.exportList = new ArrayList();
        this.fileList = new ArrayList();
        this.fileIndexes = new IntegerIndex();
        this.importList = new ArrayList();
        this.tableMap = new TreeMap();
        this.stringTable = new DualHashBidiMap();
        this.stringIndex("");
    }

    public ParseUnit build() throws IOException, RefactorException {
        if (this.parseUnit == null) {
            this.parseUnit = new ParseUnit(this.cuFile);
            this.parseUnit.setPUB(this);
        }
        this.pubFile.delete();
        this.parseUnit.treeParser01();
        return this.parseUnit;
    }

    public void build(TP01Support support) throws IOException, RefactorException {
        ParseUnit pu = support.getParseUnit();
        assert (pu.getRootScope() != null);
        this.tree = pu.getTopNode();
        this._refresh();
        this.pubFile.getParentFile().mkdirs();
        BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(this.pubFile));
        DataOutputStream out = new DataOutputStream(fileOut);
        this.writeVersion(out);
        this.writeFileIndex(out);
        this.writeHeader(out, pu.getRootScope());
        ArrayList<Symbol> rootSymbols = pu.getRootScope().getAllSymbols();
        this.writeSchemaSegment(out, rootSymbols);
        this.writeImportSegment(out, rootSymbols);
        this.writeExportSegment(out, rootSymbols);
        this.writeTree(out, this.tree);
        this.writeStrings(out);
        out.close();
    }

    public void copySchemaTableLowercaseNamesInto(Collection c) {
        c.addAll(this.tableMap.keySet());
    }

    public void copySchemaFieldLowercaseNamesInto(Collection c, String fromTableName) {
        TableRef tableRef = this.tableMap.get(fromTableName.toLowerCase());
        if (tableRef == null) {
            return;
        }
        for (String fieldName : tableRef.fieldMap.keySet()) {
            c.add(fieldName);
        }
    }

    public String getClassName() {
        return this.unitClassName;
    }

    public SymbolRef[] getExportTable() {
        SymbolRef[] ret = new SymbolRef[this.exportList.size()];
        this.exportList.toArray(ret);
        return ret;
    }

    public SymbolRef[] getImportTable() {
        SymbolRef[] ret = new SymbolRef[this.importList.size()];
        this.importList.toArray(ret);
        return ret;
    }

    private DataInputStream getDataInputStream() {
        try {
            BufferedInputStream fileIn = new BufferedInputStream(new FileInputStream(this.pubFile));
            DataInputStream inStream = new DataInputStream(fileIn);
            return inStream;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public ParseUnit getParseUnit() {
        return this.parseUnit;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public long getTimestamp() {
        if (this.pubFile == null) {
            return 0L;
        }
        return this.pubFile.lastModified();
    }

    public ProgramRootNode getTree() {
        return this.tree;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public boolean load() {
        return this.loadTo(100);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadTo(int lastSegmentToLoad) {
        block33: {
            block32: {
                this._refresh();
                if (lastSegmentToLoad >= 15) {
                    this.checked = true;
                }
                if (!this.usingNonlocalInputBlob) {
                    if (!this.pubFile.exists()) {
                        return false;
                    }
                    if (this.cuFile.lastModified() > this.pubFile.lastModified()) {
                        return false;
                    }
                    if (lastSegmentToLoad == 5) {
                        return true;
                    }
                    this.inStream = this.getDataInputStream();
                    if (this.inStream == null) {
                        return false;
                    }
                }
                if (!this.readVersion(this.inStream)) break block32;
                this.readFileIndex(this.inStream);
                if (this.usingNonlocalInputBlob || this.testTimeStamps()) break block33;
            }
            try {
                this.inStream.close();
                return false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        this.current = true;
        if (lastSegmentToLoad == 10) {
            return true;
        }
        try {
            this.readHeader(this.inStream);
            if (lastSegmentToLoad == 15) {
                return true;
            }
            this.readSchema(this.inStream);
            if (lastSegmentToLoad == 20) {
                return true;
            }
            this.readImportSegment(this.inStream);
            if (lastSegmentToLoad == 30) {
                return true;
            }
            this.readExportSegment(this.inStream);
            if (lastSegmentToLoad == 40) {
                return true;
            }
            this.nodeCount = -1;
            this.tree = (ProgramRootNode)this.readTree(this.inStream);
            if (lastSegmentToLoad == 50) {
                return true;
            }
            this.readStrings(this.inStream);
            this.setStrings(this.tree);
            return true;
        }
        catch (IOException iOException) {
            try {
                this.inStream.close();
                return false;
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return false;
        }
    }

    public static String pubDirFileName(String fullPath) {
        String path2 = fullPath.charAt(1) == ':' ? String.valueOf(fullPath.substring(0, 1)) + "_" + fullPath.substring(2) : fullPath;
        return String.valueOf(RefactorSession.getInstance().getProRefactorProjectDir()) + "/pubs/" + path2;
    }

    private void readExportSegment(DataInputStream in) throws IOException {
        SymbolRef symbolRef;
        while ((symbolRef = this.readSymbol(in)) != null) {
            this.exportList.add(symbolRef);
        }
    }

    private void readFileIndex(DataInputStream in) throws IOException {
        while (true) {
            int index = in.readInt();
            String filename = in.readUTF();
            if (index == -1) break;
            this.fileList.add(filename);
            this.fileIndexes.add(filename);
        }
    }

    private void readHeader(DataInputStream in) throws IOException {
        this.unitClassName = in.readUTF();
        if (this.unitClassName.length() == 0) {
            this.unitClassName = null;
        }
        this.superClassName = in.readUTF();
        if (this.superClassName.length() == 0) {
            this.superClassName = null;
        }
    }

    private void readImportSegment(DataInputStream in) throws IOException {
        SymbolRef symbolRef;
        while ((symbolRef = this.readSymbol(in)) != null) {
            this.importList.add(symbolRef);
        }
    }

    private void readSchema(DataInputStream in) throws IOException {
        String tableName;
        while ((tableName = in.readUTF()).length() != 0) {
            String fieldName;
            TableRef tableRef = new TableRef(tableName);
            this.tableMap.put(tableName.toLowerCase(), tableRef);
            while ((fieldName = in.readUTF()).length() != 0) {
                tableRef.fieldMap.put(fieldName.toLowerCase(), fieldName);
            }
        }
    }

    private void readStrings(DataInputStream in) throws IOException {
        int size = in.readInt();
        this.stringArray = new String[size];
        int i = 0;
        while (i < size) {
            this.stringArray[i] = in.readUTF();
            ++i;
        }
    }

    private SymbolRef readSymbol(DataInputStream in) throws IOException {
        SymbolRef symbolRef = new SymbolRef(in.readInt(), in.readUTF());
        if (symbolRef.progressType == -1) {
            return null;
        }
        symbolRef.dataType = in.readInt();
        if (symbolRef.dataType == 1101) {
            symbolRef.classSymbolRefName = in.readUTF();
        }
        return symbolRef;
    }

    private JPNode readTree(DataInputStream in) throws IOException {
        int nodeClass = in.readInt();
        if (nodeClass == -1) {
            return null;
        }
        JPNode node = NodeFactory.createByIndex(nodeClass);
        node.setFilenameList(this.fileIndexes);
        node.setNodeNum(++this.nodeCount);
        node.setType(in.readInt());
        node.setFileIndex(in.readShort());
        node.setLine(in.readInt());
        node.setColumn(in.readShort());
        node.setSourceNum(in.readInt());
        int key = in.readInt();
        int value = in.readInt();
        while (key != -1) {
            node.attrSet(key, value);
            key = in.readInt();
            value = in.readInt();
        }
        node.setFirstChild(this.readTree(in));
        node.setParentInChildren();
        node.setNextSiblingWithLinks((AST)this.readTree(in));
        return node;
    }

    private boolean readVersion(DataInputStream in) throws IOException {
        return in.readInt() == 11;
    }

    public void setDataInputStream(DataInputStream inStream) {
        this.inStream = inStream;
        this.usingNonlocalInputBlob = true;
    }

    public void setParseUnit(ParseUnit pu) {
        this.parseUnit = pu;
        if (pu.getPUB() != this) {
            pu.setPUB(this);
        }
    }

    private void setStrings(JPNode node) {
        if (node == null) {
            return;
        }
        int index = node.attrGet(49001);
        if (index > 0) {
            node.setText(this.stringArray[index]);
        }
        if ((index = node.attrGet(49002)) > 0) {
            node.setComments(this.stringArray[index]);
        }
        if ((index = node.attrGet(1500)) > 0) {
            ((ProparseDirectiveNode)node).setDirectiveText(this.stringArray[index]);
        }
        if ((index = node.attrGet(2400)) > 0) {
            node.attrSetS("qualified-class", this.stringArray[index]);
        }
        this.setStrings(node.firstChild());
        this.setStrings(node.nextSibling());
    }

    private int stringIndex(String s) {
        Integer index = (Integer)this.stringTable.getKey((Object)s);
        if (index == null) {
            index = new Integer(this.stringTable.size());
            this.stringTable.put((Object)index, (Object)s);
        }
        return index;
    }

    private boolean testTimeStamps() {
        long pubTime = this.pubFile.lastModified();
        for (String filename : this.fileList) {
            if (filename == null || filename.length() == 0) continue;
            File file = FileStuff.findFile(filename);
            if (file == null) {
                return false;
            }
            if (file.lastModified() <= pubTime) continue;
            return false;
        }
        return true;
    }

    private void writeExportSegment(DataOutputStream out, List rootSymbols) throws IOException {
        for (Symbol symbol : rootSymbols) {
            if (!symbol.isExported()) continue;
            this.writeSymbol(out, symbol);
        }
        out.writeInt(-1);
        out.writeUTF("");
    }

    private void writeFileIndex(DataOutputStream out) throws IOException {
        String[] files = this.tree.getFilenames();
        int i = 0;
        while (i < files.length) {
            out.writeInt(i);
            out.writeUTF(files[i]);
            ++i;
        }
        out.writeInt(-1);
        out.writeUTF("");
    }

    private void writeHeader(DataOutputStream out, SymbolScopeRoot unitScope) throws IOException {
        String s = unitScope.getClassName();
        if (s != null) {
            out.writeUTF(s);
        } else {
            out.writeUTF("");
        }
        SymbolScopeSuper superScope = (SymbolScopeSuper)unitScope.getParentScope();
        if (superScope != null) {
            out.writeUTF(superScope.getClassName());
        } else {
            out.writeUTF("");
        }
    }

    private void writeImportSegment(DataOutputStream out, List rootSymbols) throws IOException {
        for (Symbol symbol : rootSymbols) {
            if (!symbol.isImported()) continue;
            this.writeSymbol(out, symbol);
        }
        out.writeInt(-1);
        out.writeUTF("");
    }

    private void writeSymbol(DataOutputStream out, Symbol symbol) throws IOException {
        out.writeInt(symbol.getProgressType());
        out.writeUTF(symbol.fullName());
        if (symbol instanceof Primative) {
            Primative primative = (Primative)((Object)symbol);
            int dataType = primative.getDataType().getTokenType();
            out.writeInt(dataType);
            if (dataType == 1101) {
                out.writeUTF(primative.getClassName());
            }
        } else {
            out.writeInt(0);
        }
    }

    private void writeTree(DataOutputStream out, JPNode node) throws IOException {
        int attrVal;
        String comments;
        int nodeType = node.getType();
        out.writeInt(node.getSubtypeIndex());
        out.writeInt(nodeType);
        out.writeShort(node.getFileIndex());
        out.writeInt(node.getLine());
        out.writeShort(node.getColumn());
        out.writeInt(node.getSourceNum());
        if (!TokenTypes.hasDefaultText(nodeType)) {
            out.writeInt(49001);
            out.writeInt(this.stringIndex(node.getText()));
        }
        if ((comments = node.getComments()) != null) {
            out.writeInt(49002);
            out.writeInt(this.stringIndex(comments));
        }
        if (node.attrGet(1400) == 1) {
            out.writeInt(1400);
            out.writeInt(1);
            out.writeInt(1300);
            out.writeInt(node.getState2());
        }
        if ((attrVal = node.attrGet(1100)) > 0) {
            out.writeInt(1100);
            out.writeInt(attrVal);
        }
        if (node instanceof ProparseDirectiveNode) {
            out.writeInt(1500);
            out.writeInt(this.stringIndex(((ProparseDirectiveNode)node).getDirectiveText()));
        }
        if ((attrVal = node.attrGet(1200)) > 0) {
            out.writeInt(1200);
            out.writeInt(attrVal);
        }
        if ((attrVal = node.attrGet(2000)) > 0) {
            out.writeInt(2000);
            out.writeInt(attrVal);
        }
        if (nodeType == 1125) {
            out.writeInt(2400);
            out.writeInt(this.stringIndex(node.attrGetS("qualified-class")));
        }
        out.writeInt(-1);
        out.writeInt(-1);
        JPNode next = node.firstChild();
        if (next != null) {
            this.writeTree(out, next);
        } else {
            out.writeInt(-1);
        }
        next = node.nextSibling();
        if (next != null) {
            this.writeTree(out, next);
        } else {
            out.writeInt(-1);
        }
    }

    private void writeSchemaSegment(DataOutputStream out, List rootSymbols) throws IOException {
        for (Object obj : rootSymbols) {
            Field field;
            Table table;
            if (obj instanceof TableBuffer) {
                Table table2 = ((TableBuffer)obj).getTable();
                if (table2.getStoretype() != 1102) continue;
                this.writeSchema_addTable(table2);
                continue;
            }
            if (!(obj instanceof FieldBuffer) || (table = (field = ((FieldBuffer)obj).getField()).getTable()).getStoretype() != 1102) continue;
            TableRef tableRef = this.writeSchema_addTable(table);
            tableRef.fieldMap.put(field.getName().toLowerCase(), field.getName());
        }
        for (TableRef tableRef : this.tableMap.values()) {
            out.writeUTF(tableRef.name);
            for (String fieldName : tableRef.fieldMap.values()) {
                out.writeUTF(fieldName);
            }
            out.writeUTF("");
        }
        out.writeUTF("");
    }

    private TableRef writeSchema_addTable(Table table) {
        String name = String.valueOf(table.getDatabase().getName()) + "." + table.getName();
        String lowerName = name.toLowerCase();
        TableRef tableRef = this.tableMap.get(lowerName);
        if (tableRef != null) {
            return tableRef;
        }
        tableRef = new TableRef(name);
        this.tableMap.put(lowerName, tableRef);
        return tableRef;
    }

    private void writeStrings(DataOutputStream out) throws IOException {
        int size = this.stringTable.size();
        out.writeInt(size);
        int i = 0;
        while (i < size) {
            out.writeUTF((String)this.stringTable.get((Object)new Integer(i)));
            ++i;
        }
    }

    private void writeVersion(DataOutputStream out) throws IOException {
        out.writeInt(11);
    }

    public class SymbolRef {
        public int progressType;
        public int dataType = 0;
        public String symbolName;
        public String classSymbolRefName = null;

        SymbolRef(int progressType, String symbolName) {
            this.progressType = progressType;
            this.symbolName = symbolName;
        }
    }

    private class TableRef {
        String name;
        TreeMap<String, String> fieldMap = new TreeMap();

        TableRef(String name) {
            this.name = name;
        }
    }
}

