/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.refactor;

import com.joanju.proparse.Environment;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import org.prorefactor.core.schema.Schema;
import org.prorefactor.refactor.IDE;
import org.prorefactor.refactor.IDEDefault;
import org.prorefactor.refactor.settings.ApplicationSettings;
import org.prorefactor.refactor.settings.ProgressProjectSettings;
import org.prorefactor.refactor.settings.ProparseProjectSettings;

public class RefactorSession {
    private boolean projectBinariesEnabled = false;
    private long timeStamp;
    private ApplicationSettings appSettings = null;
    private Environment env = Environment.instance();
    private IDE ide = new IDEDefault(this);
    private String projectName = null;
    private ProgressProjectSettings progressSettings = null;
    private ProparseProjectSettings proparseSettings = null;
    private Schema schema = Schema.getInstance();
    private String contextDirName = "";
    private static RefactorSession theInstance;

    private RefactorSession() {
        this.readAppSettings();
    }

    private void configureProparse() throws Exception {
        this.schema.clear();
        if (this.proparseSettings.schemaFile != null && this.proparseSettings.schemaFile.length() > 0) {
            this.schema.loadSchema(this.proparseSettings.schemaFile);
        }
        this.env.configSet("batch-mode", this.progressSettings.batchmode ? "true" : "false");
        this.env.configSet("keyword-all", this.proparseSettings.keywordall);
        this.env.configSet("opsys", this.progressSettings.opsys);
        this.env.configSet("propath", this.progressSettings.propath);
        this.env.configSet("proversion", this.progressSettings.proversion);
        this.env.configSet("window-system", this.progressSettings.windowSystem);
        this.schema.aliasDelete(null);
        String[] alias = this.progressSettings.dbAliases.split(",");
        int i = 0;
        while (i < alias.length - 1) {
            this.schema.aliasCreate(alias[i], alias[i + 1]);
            i += 2;
        }
    }

    public void disableParserListing() {
        this.env.configSet("listing-file", "");
    }

    public void enableParserListing() {
        this.env.configSet("listing-file", RefactorSession.getListingFileName());
    }

    public ApplicationSettings getAppSettings() {
        return this.appSettings;
    }

    public static String getAppSettingsFilename() {
        return String.valueOf(RefactorSession.getContextDirName()) + "prorefactor/settings/application.properties";
    }

    public static String getContextDirName() {
        if (theInstance != null) {
            return RefactorSession.theInstance.contextDirName;
        }
        return "";
    }

    public IDE getIDE() {
        return this.ide;
    }

    public String getIndentString() {
        String indentString;
        if (this.getProparseSettings().indentTab) {
            indentString = "\t";
        } else {
            int spaces = this.getProparseSettings().indentSpaces;
            char[] ca = new char[spaces];
            Arrays.fill(ca, ' ');
            indentString = new String(ca);
        }
        return indentString;
    }

    public static RefactorSession getInstance() {
        if (theInstance == null) {
            theInstance = new RefactorSession();
        }
        return theInstance;
    }

    public static String getListingFileName() {
        String ret = String.valueOf(RefactorSession.getContextDirName()) + "prorefactor/temp/listingfile.txt";
        new File(ret).getParentFile().mkdirs();
        return ret;
    }

    public static String getMessagesFileName() {
        return String.valueOf(RefactorSession.getContextDirName()) + "prorefactor/refactor.messages";
    }

    public boolean getProjectBinaraiesEnabled() {
        return this.projectBinariesEnabled;
    }

    public static String getProjectsDirName() {
        return String.valueOf(RefactorSession.getContextDirName()) + "prorefactor/projects/";
    }

    public ProgressProjectSettings getProgressSettings() {
        if (this.progressSettings == null) {
            this.progressSettings = new ProgressProjectSettings(null);
        }
        return this.progressSettings;
    }

    public static String getProgressSettingsFilename(String projectName) {
        return String.valueOf(RefactorSession.getProjectsDirName()) + projectName + "/progress.properties";
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ProparseProjectSettings getProparseSettings() {
        if (this.proparseSettings == null) {
            this.proparseSettings = new ProparseProjectSettings(null, null);
        }
        return this.proparseSettings;
    }

    public static String getProparseSettingsFilename(String projectName) {
        return String.valueOf(RefactorSession.getProjectsDirName()) + projectName + "/proparse.properties";
    }

    public static String getProrefactorDirName() {
        return String.valueOf(RefactorSession.getContextDirName()) + "prorefactor/";
    }

    public String getProRefactorProjectDir() {
        return String.valueOf(RefactorSession.getProjectsDirName()) + this.projectName;
    }

    public String getProRefactorProjectDir(String inputProjectName) {
        return String.valueOf(RefactorSession.getProjectsDirName()) + inputProjectName;
    }

    public File getRollbackDir() {
        File ret = new File(RefactorSession.getRollbackDirName());
        ret.mkdirs();
        return ret;
    }

    public static String getRollbackDirName() {
        String ret = String.valueOf(RefactorSession.getContextDirName()) + "prorefactor/rollback";
        new File(ret).mkdirs();
        return ret;
    }

    public File getTempDir() {
        File ret = new File(String.valueOf(this.contextDirName) + "prorefactor/temp");
        ret.mkdirs();
        return ret;
    }

    public static void invalidateCurrentSettings() {
        if (theInstance != null) {
            RefactorSession.theInstance.projectName = null;
        }
    }

    public void loadProject(String nameToLoad) throws Exception {
        if (nameToLoad == null || nameToLoad.length() == 0) {
            throw new Exception("No project selected");
        }
        if (this.projectName != null && this.projectName.equals(nameToLoad) && this.schemaFileIsCurrent()) {
            return;
        }
        try {
            this.appSettings.loadSettings();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.progressSettings = new ProgressProjectSettings(RefactorSession.getProgressSettingsFilename(nameToLoad));
        try {
            this.progressSettings.loadSettings();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.proparseSettings = new ProparseProjectSettings(RefactorSession.getProparseSettingsFilename(nameToLoad), nameToLoad);
        try {
            this.proparseSettings.loadSettings();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.configureProparse();
        this.projectName = nameToLoad;
        this.timeStamp = System.currentTimeMillis();
    }

    public void loadProjectForced(String nameToLoad) throws Exception {
        RefactorSession.invalidateCurrentSettings();
        this.loadProject(nameToLoad);
    }

    public void loadProjectForFile(File file) throws Exception {
        String s = this.getIDE().getProjectRelativePath(file)[0];
        this.loadProject(s);
    }

    public void loadProjectPropertiesFromDirectory(String fullyQualifiedDirName) throws Exception {
        this.progressSettings = new ProgressProjectSettings(String.valueOf(fullyQualifiedDirName) + "/progress.properties");
        this.progressSettings.loadSettings();
        this.proparseSettings = new ProparseProjectSettings(String.valueOf(fullyQualifiedDirName) + "/proparse.properties", "");
        this.proparseSettings.loadSettings();
        this.configureProparse();
    }

    private void readAppSettings() {
        this.appSettings = new ApplicationSettings(RefactorSession.getAppSettingsFilename());
        try {
            this.appSettings.loadSettings();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean schemaFileIsCurrent() {
        assert (this.proparseSettings != null);
        File schemaFile = new File(this.proparseSettings.schemaFile);
        if (!schemaFile.exists()) {
            return true;
        }
        return schemaFile.lastModified() < this.timeStamp;
    }

    public void setContextDirName(String contextDirName) {
        this.contextDirName = contextDirName;
        this.readAppSettings();
    }

    public RefactorSession setIDE(IDE ide) {
        this.ide = ide;
        return this;
    }

    public void setProjectBinariesEnabledOff() {
        this.projectBinariesEnabled = false;
    }

    public void setProjectBinariesEnabledOn() {
        this.projectBinariesEnabled = true;
    }
}

