/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.refactor.settings;

import org.prorefactor.refactor.settings.Settings;

public class ProgressProjectSettings
extends Settings {
    public boolean batchmode = false;
    public String dbAliases = "";
    public String opsys = "WIN32";
    public String propath = "";
    public String proversion = "";
    public String windowSystem = "MS-WIN95";

    public ProgressProjectSettings(String propsFilename) {
        super(propsFilename);
        this.propertiesDescription = "Progress Project Settings";
    }

    public void loadSettings() throws Exception {
        super.loadSettings();
        String tmp = this.properties.getProperty("batch_mode");
        this.batchmode = tmp != null && tmp.equals("true");
        this.dbAliases = this.getVal(this.dbAliases, "database_aliases");
        this.opsys = this.getVal(this.opsys, "opsys");
        this.propath = this.getVal(this.propath, "propath");
        this.proversion = this.getVal(this.proversion, "proversion");
        this.windowSystem = this.getVal(this.windowSystem, "window_system");
    }

    public void saveSettings() throws Exception {
        this.properties.put("batch_mode", this.batchmode ? "true" : "false");
        this.properties.put("database_aliases", this.dbAliases);
        this.properties.put("opsys", this.opsys);
        this.properties.put("propath", this.propath);
        this.properties.put("proversion", this.proversion);
        this.properties.put("window_system", this.windowSystem);
        super.saveSettings();
    }
}

