/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.refactor.settings;

import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.refactor.settings.Settings;

public class ProparseProjectSettings
extends Settings {
    public boolean capKeyword = true;
    public boolean indentTab = false;
    public int indentSpaces = 3;
    public String keywordall = "";
    public String rCodeDir = "";
    public String schemaFile;

    public ProparseProjectSettings(String propsFilename, String projectName) {
        super(propsFilename);
        this.propertiesDescription = "Proparse/Refactor Project Settings";
        this.schemaFile = String.valueOf(RefactorSession.getProjectsDirName()) + projectName + "/proparse.schema";
    }

    public void loadSettings() throws Exception {
        super.loadSettings();
        String tmp = this.properties.getProperty("capitalize_keywords");
        this.capKeyword = tmp == null || tmp.equals("true");
        tmp = this.properties.getProperty("indent_tab");
        if (tmp != null) {
            this.indentTab = tmp.equals("true");
        }
        if ((tmp = this.properties.getProperty("indent_spaces")) != null) {
            this.indentSpaces = Integer.parseInt(tmp);
        }
        this.keywordall = this.getVal(this.keywordall, "keywordall");
        this.rCodeDir = this.getVal(this.rCodeDir, "r_code_dir");
        this.schemaFile = this.getVal(this.schemaFile, "schema_file");
    }

    public void saveSettings() throws Exception {
        this.properties.put("capitalize_keywords", this.capKeyword ? "true" : "false");
        this.properties.put("indent_tab", this.indentTab ? "true" : "false");
        this.properties.put("indent_spaces", Integer.toString(this.indentSpaces));
        this.properties.put("keywordall", this.keywordall);
        this.properties.put("r_code_dir", this.rCodeDir);
        this.properties.put("schema_file", this.schemaFile);
        super.saveSettings();
    }
}

