/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.refactor.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public abstract class Settings {
    protected Properties properties = new Properties();
    protected String propertiesDescription = "";
    protected String propsFilename;

    public Settings(String propsFilename) {
        this.propsFilename = propsFilename;
    }

    protected String getVal(String orig, String propertyName) {
        String tmp = this.properties.getProperty(propertyName);
        if (tmp != null) {
            return tmp;
        }
        return orig;
    }

    public void loadSettings() throws Exception {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.propsFilename);
            this.properties.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void saveSettings() throws Exception {
        FileOutputStream out = null;
        try {
            File theFile = new File(this.propsFilename);
            File theDir = theFile.getParentFile();
            theDir.mkdirs();
            out = new FileOutputStream(theFile);
            this.properties.store(out, this.propertiesDescription);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

