/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.refactor.unittest;

import java.io.File;
import java.util.ArrayList;
import junit.textui.TestRunner;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.unittest.UnitTestBase2;
import org.prorefactor.nodetypes.ProgramRootNode;
import org.prorefactor.refactor.PUB;
import org.prorefactor.refactor.RefactorSession;

public class PUBTest
extends UnitTestBase2 {
    private RefactorSession refpack = RefactorSession.getInstance();
    private String relPath = "data/pub/test01.p";
    private File parseFile;
    private PUB pub;

    public PUBTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(PUBTest.class);
    }

    protected void setUp() throws Exception {
        this.refpack.loadProject("sports2000");
        RefactorSession.getInstance().setProjectBinariesEnabledOn();
        this.parseFile = new File(this.relPath);
        this.pub = new PUB(this.parseFile.getCanonicalPath());
    }

    public void testBuild() throws Exception {
        this.pub.build();
        this.pub = new PUB(this.parseFile.getCanonicalPath());
        PUBTest.assertTrue((boolean)this.pub.load());
    }

    public void testIncludeName() throws Exception {
        PUBTest.assertTrue((boolean)this.pub.load());
        String[] fileIndex = this.pub.getTree().getFilenames();
        File iGet = new File(fileIndex[1]);
        File iBase = new File("data/pub/test01.i");
        PUBTest.assertTrue((boolean)iGet.getCanonicalPath().equals(iBase.getCanonicalPath()));
    }

    public void testTimeStamp() throws Exception {
        long origTime = this.parseFile.lastModified();
        PUBTest.assertTrue((boolean)this.parseFile.setLastModified(System.currentTimeMillis() + 10000L));
        PUBTest.assertFalse((boolean)this.pub.load());
        PUBTest.assertTrue((boolean)this.parseFile.setLastModified(origTime));
        PUBTest.assertTrue((boolean)this.pub.load());
    }

    public void testIncludeTimeStamp() throws Exception {
        File iBase = new File("data/pub/test01.i");
        long origTime = iBase.lastModified();
        iBase.setLastModified(System.currentTimeMillis() + 10000L);
        PUBTest.assertFalse((boolean)this.pub.load());
        iBase.setLastModified(origTime);
        PUBTest.assertTrue((boolean)this.pub.load());
    }

    public void testSchemaLoad() throws Exception {
        PUBTest.assertTrue((boolean)this.pub.load());
        ArrayList tables = new ArrayList();
        this.pub.copySchemaTableLowercaseNamesInto(tables);
        PUBTest.assertTrue((tables.size() == 1 ? 1 : 0) != 0);
        PUBTest.assertTrue((boolean)tables.get(0).toString().equals("sports2000.customer"));
        ArrayList fields = new ArrayList();
        this.pub.copySchemaFieldLowercaseNamesInto(fields, "sports2000.customer");
        PUBTest.assertTrue((fields.size() == 1 ? 1 : 0) != 0);
        PUBTest.assertTrue((boolean)fields.get(0).toString().equals("name"));
    }

    public void testImportTable() throws Exception {
        PUBTest.assertTrue((boolean)this.pub.load());
        PUB.SymbolRef[] imports = this.pub.getImportTable();
        PUB.SymbolRef imp = imports[0];
        PUBTest.assertTrue((imp.progressType == 841 ? 1 : 0) != 0);
        PUBTest.assertTrue((boolean)imp.symbolName.equals("sharedChar"));
    }

    public void testExportTable() throws Exception {
        PUBTest.assertTrue((boolean)this.pub.load());
        PUB.SymbolRef[] exports = this.pub.getExportTable();
        PUB.SymbolRef exp = exports[0];
        PUBTest.assertTrue((exp.progressType == 296 ? 1 : 0) != 0);
        PUBTest.assertTrue((boolean)exp.symbolName.equals("myFrame"));
    }

    public void testComments() throws Exception {
        PUBTest.assertTrue((boolean)this.pub.load());
        ProgramRootNode topNode = this.pub.getTree();
        PUBTest.assertTrue((topNode.firstNaturalChild().getComments().length() > 2 ? 1 : 0) != 0);
    }

    public void testText() throws Exception {
        PUBTest.assertTrue((boolean)this.pub.load());
        ProgramRootNode topNode = this.pub.getTree();
        for (JPNode node : topNode.query(913)) {
            PUBTest.assertTrue((node.getText().length() > 0 ? 1 : 0) != 0);
        }
    }
}

