/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.reports;

import java.io.BufferedWriter;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.TokenTypes;
import org.prorefactor.core.schema.Field;
import org.prorefactor.io.LogWriter;
import org.prorefactor.nodetypes.FieldRefNode;
import org.prorefactor.treeparser.FieldBuffer;
import org.prorefactor.treeparser.ParseUnit;
import org.prorefactor.treeparser.Symbol;

public class HowUsed {
    BufferedWriter reportWriter;
    Field reportField;
    LogWriter log;

    public HowUsed(BufferedWriter reportWriter, LogWriter log, Field reportField) {
        this.reportWriter = reportWriter;
        this.log = log;
        this.reportField = reportField;
    }

    public void report(ParseUnit pu) throws Exception {
        this.walkTree(pu.getTopNode());
    }

    private void walkTree(JPNode node) throws Exception {
        Symbol symbol;
        if (node == null) {
            return;
        }
        boolean match = false;
        if (node instanceof FieldRefNode && (symbol = node.getSymbol()) != null && symbol instanceof FieldBuffer && ((FieldBuffer)symbol).getField() == this.reportField) {
            match = true;
        }
        if (match) {
            this.printReference(node);
        } else {
            this.walkTree(node.firstChild());
        }
        this.walkTree(node.nextSibling());
    }

    private void printReference(JPNode node) throws Exception {
        JPNode stateHead = node.parent();
        while (!stateHead.isStateHead()) {
            stateHead = stateHead.parent();
        }
        this.reportWriter.newLine();
        this.print4(stateHead, stateHead.getType());
        int state2 = stateHead.getState2();
        if (state2 != 0) {
            this.reportWriter.write(" ");
            this.reportWriter.write(TokenTypes.getDefaultText(state2).toLowerCase());
        }
        this.reportWriter.write(" ... ");
        this.print2(node.parent(), false);
        this.reportWriter.newLine();
    }

    private void print2(JPNode node, boolean writeSiblings) throws Exception {
        if (node == null) {
            return;
        }
        JPNode firstChild = node.firstChild();
        JPNode nextSibling = node.nextSibling();
        if (node.attrGet(1200) == 1) {
            this.print2(firstChild, false);
            this.print3(node);
            this.print2(firstChild.nextSibling(), true);
        } else {
            this.print3(node);
            this.print2(firstChild, true);
        }
        if (writeSiblings) {
            this.print2(nextSibling, true);
        }
    }

    protected void print3(JPNode node) throws Exception {
        int type = node.getType();
        if (!TokenTypes.isNatural(type)) {
            return;
        }
        if (type != 9 && type != 917 && type != 7 && node.prevNode().getType() != 7) {
            this.reportWriter.write(" ");
        }
        this.print4(node, type);
    }

    protected void print4(JPNode node, int type) throws Exception {
        if (TokenTypes.hasDefaultText(type)) {
            this.reportWriter.write(TokenTypes.getDefaultText(type).toLowerCase());
            return;
        }
        this.reportWriter.write(node.getText());
    }
}

