/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.reports;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import org.prorefactor.Console;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.Schema;
import org.prorefactor.io.LogWriter;
import org.prorefactor.refactor.PUB;
import org.prorefactor.refactor.RefactorException;
import org.prorefactor.reports.HowUsed;
import org.prorefactor.treeparser.ParseUnit;

public class HowUsedConsole
extends Console {
    BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    HashSet<String> fieldNames = new HashSet();
    BufferedWriter reportOut;
    HowUsed howUsed;
    String dbTableName;
    String fieldName;

    public void go() throws Exception {
        Collection files = null;
        System.out.println();
        System.out.println("Enter the name of a file to read a list of");
        System.out.println("compile units to report on. The file should contain");
        System.out.println("one fully qualified compile unit file name per line.");
        System.out.println("*OR* enter blank to parse all .p, .w, and");
        System.out.println(".cls files in a directory tree.");
        System.out.print("File name (or blank): ");
        String listFileName = this.reader.readLine();
        File dir = null;
        if (listFileName.trim().length() > 0) {
            files = this.buildCUListFromFile(listFileName);
        } else {
            System.out.println("Enter the name of the directory to scan.");
            dir = super.promptDirectory();
            if (dir == null) {
                return;
            }
        }
        System.out.println();
        System.out.println("Enter the fully qualified ldbname.tablename.fieldname.");
        System.out.print("Field name: ");
        String fullFieldName = this.reader.readLine().toLowerCase();
        if (fullFieldName == null || fullFieldName.length() == 0) {
            return;
        }
        String[] parts = fullFieldName.split("\\.");
        if (parts.length != 3) {
            System.out.println("Name must be fully qualified ldbname.tablename.fieldname.");
            return;
        }
        this.fieldName = parts[2];
        this.dbTableName = String.valueOf(parts[0]) + "." + parts[1];
        Field reportField = Schema.getInstance().lookupField(parts[0], parts[1], parts[2]);
        if (reportField == null) {
            System.out.println("That field is not in the project's schema.");
            return;
        }
        System.out.println();
        System.out.println("Enter the name of the file to write the report to.");
        System.out.print("Output file: ");
        String outFileName = this.reader.readLine();
        if (outFileName == null || outFileName.length() == 0) {
            return;
        }
        this.reportOut = new BufferedWriter(new FileWriter(new File(outFileName)));
        LogWriter log = new LogWriter(System.out);
        this.howUsed = new HowUsed(this.reportOut, log, reportField);
        try {
            if (dir != null) {
                files = this.findCompileUnits(dir);
            }
            int currFileNum = 0;
            String totalFiles = "/" + files.size() + " ";
            for (File cuFile : files) {
                log.log(String.valueOf(Integer.toString(++currFileNum)) + totalFiles + cuFile.toString());
                this.processOne(new ParseUnit(cuFile), log);
            }
        }
        finally {
            this.reportOut.close();
            log.close();
        }
    }

    private void processOne(ParseUnit pu, LogWriter log) throws Exception {
        try {
            PUB pub = pu.getPUB();
            boolean wasCurrent = pub.loadTo(20);
            if (!wasCurrent) {
                pub.build();
            }
            if (!this.usesField(pub)) {
                return;
            }
            this.reportOut.write(pu.getFile().toString());
            this.reportOut.newLine();
            if (wasCurrent) {
                pub.load();
                pu.treeParser01();
            }
            this.howUsed.report(pu);
            this.reportOut.newLine();
            this.reportOut.newLine();
            this.reportOut.flush();
        }
        catch (RefactorException e) {
            log.logException(pu.getFile().toString(), e);
        }
    }

    private boolean usesField(PUB pub) {
        this.fieldNames.clear();
        pub.copySchemaFieldLowercaseNamesInto(this.fieldNames, this.dbTableName);
        return this.fieldNames.contains(this.fieldName);
    }
}

