/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import com.joanju.DataXferStream;
import com.joanju.Xferable;
import java.io.IOException;
import org.prorefactor.treeparser.Block;
import org.prorefactor.treeparser.TableBuffer;

public class BufferScope
implements Xferable {
    private int strength;
    private Block block;
    private TableBuffer symbol;
    public static final int STRONG = 1;
    public static final int WEAK = 2;
    public static final int REFERENCE = 3;
    public static final int HIDDEN_CURSOR = 4;

    public BufferScope() {
    }

    public BufferScope(Block block, TableBuffer symbol, int strength) {
        this.block = block;
        this.symbol = symbol;
        this.strength = strength;
    }

    public Block getBlock() {
        return this.block;
    }

    int getStrength() {
        return this.strength;
    }

    public TableBuffer getSymbol() {
        return this.symbol;
    }

    public boolean isStrong() {
        return this.strength == 1;
    }

    public boolean isWeak() {
        return this.strength == 2;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public void writeXferBytes(DataXferStream out) throws IOException {
        out.writeRef(this.block);
        out.writeInt(this.strength);
        out.writeRef(this.symbol);
    }

    public void writeXferSchema(DataXferStream out) throws IOException {
        out.schemaRef("block");
        out.schemaInt("strengthCode");
        out.schemaRef("tableBuffer");
    }
}

