/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import antlr.SemanticException;
import java.util.ArrayList;
import org.prorefactor.core.JPNode;
import org.prorefactor.treeparser.Parameter;
import org.prorefactor.treeparser.RunHandle;
import org.prorefactor.treeparser.SemanticRecord;
import org.prorefactor.treeparser.Symbol;
import org.prorefactor.treeparser.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Call
extends SemanticRecord {
    private ArrayList<Parameter> parameters = new ArrayList();
    private JPNode persistentHandleNode = null;
    private JPNode runHandleNode = null;
    private RunHandle runHandle = null;
    private String externalName = null;
    private String internalName = null;
    private String runArgument = null;
    private Variable persistentHandleVar;

    public Call(String externalName, String internalName) {
        this.internalName = internalName;
        this.externalName = externalName;
    }

    public Call(JPNode node) {
        super(node);
    }

    public void addParameter(Parameter p) {
        this.parameters.add(p);
    }

    public String baseFilename(String filename) {
        int startAt = filename.lastIndexOf("/") + 1;
        return filename.substring(startAt);
    }

    public boolean equals(Object other) {
        if (other.getClass() == this.getClass()) {
            Call otherCall = (Call)other;
            return this.id().equalsIgnoreCase(otherCall.id());
        }
        return false;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getLocalTarget() {
        return this.internalName;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    public String getRunArgument() {
        return this.runArgument;
    }

    public String id() {
        return String.valueOf(this.externalName) + "." + this.internalName;
    }

    public boolean isLocal() {
        return this.getFilename() == this.externalName;
    }

    public boolean isPersistent() {
        return this.persistentHandleNode != null;
    }

    public boolean isInHandle() {
        return this.runHandleNode != null;
    }

    public void setPersistentHandleNode(JPNode node) {
        this.persistentHandleNode = node;
    }

    public void setPersistentHandleVar(Variable var) {
        this.persistentHandleVar = var;
    }

    public void setRunArgument(String f) {
        this.runArgument = f;
    }

    public void setRunHandle(RunHandle handle) {
        this.runHandle = handle;
    }

    public void setRunHandleNode(JPNode node) {
        this.runHandleNode = node;
    }

    public String toString() {
        return this.id();
    }

    public void wrapUp(boolean definedInternal) throws SemanticException {
        if (this.isInHandle()) {
            this.internalName = this.runArgument;
            Symbol s = this.runHandleNode.getSymbol();
            if (s != null && s instanceof Variable) {
                this.runHandle = (RunHandle)((Variable)s).getValue();
                if (this.runHandle != null) {
                    this.externalName = (String)this.runHandle.getValue();
                }
            }
        } else if (definedInternal) {
            this.internalName = this.runArgument;
            this.externalName = this.baseFilename(this.getFilename());
        } else if (this.isPersistent()) {
            this.internalName = null;
            this.externalName = this.runArgument;
            Symbol s = this.persistentHandleNode.getSymbol();
            if (s != null && s instanceof Variable) {
                this.persistentHandleVar = (Variable)s;
                RunHandle hValue = new RunHandle();
                hValue.setValue(this.externalName);
                this.persistentHandleVar.setValue(hValue);
            }
        } else {
            this.internalName = null;
            this.externalName = this.runArgument;
        }
    }
}

