/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import com.joanju.DataXferStream;
import com.joanju.Xferable;
import java.io.IOException;
import java.util.HashMap;

public class DataType
implements Xferable {
    private Integer tokenType;
    private String progressName;
    private static HashMap<String, DataType> nameMap = new HashMap();
    private static HashMap<Integer, DataType> tokenTypeMap = new HashMap();
    public static final DataType BIGINT = new DataType(1092, "BIGINT");
    public static final DataType BLOB = new DataType(1023, "BLOB");
    public static final DataType BYTE = new DataType(87, "BYTE");
    public static final DataType CHARACTER = new DataType(103, "CHARACTER");
    public static final DataType CLASS = new DataType(1101, "CLASS");
    public static final DataType CLOB = new DataType(1024, "CLOB");
    public static final DataType COMHANDLE = new DataType(128, "COM-HANDLE");
    public static final DataType DATE = new DataType(166, "DATE");
    public static final DataType DATETIME = new DataType(1025, "DATETIME");
    public static final DataType DATETIMETZ = new DataType(1026, "DATETIME-TZ");
    public static final DataType DECIMAL = new DataType(183, "DECIMAL");
    public static final DataType DOUBLE = new DataType(213, "DOUBLE");
    public static final DataType FIXCHAR = new DataType(1094, "FIXCHAR");
    public static final DataType FLOAT = new DataType(286, "FLOAT");
    public static final DataType HANDLE = new DataType(342, "HANDLE");
    public static final DataType INTEGER = new DataType(385, "INTEGER");
    public static final DataType INT64 = new DataType(1148, "INT64");
    public static final DataType LONG = new DataType(440, "LONG");
    public static final DataType LONGCHAR = new DataType(1027, "LONGCHAR");
    public static final DataType LOGICAL = new DataType(439, "LOGICAL");
    public static final DataType MEMPTR = new DataType(456, "MEMPTR");
    public static final DataType NUMERIC = new DataType(533, "NUMERIC");
    public static final DataType RAW = new DataType(634, "RAW");
    public static final DataType RECID = new DataType(643, "RECID");
    public static final DataType ROWID = new DataType(679, "ROWID");
    public static final DataType SHORT = new DataType(1048, "SHORT");
    public static final DataType TIME = new DataType(788, "TIME");
    public static final DataType TIMESTAMP = new DataType(1093, "TIMESTAMP");
    public static final DataType TYPE_NAME = CLASS;
    public static final DataType UNSIGNEDSHORT = new DataType(1050, "UNSIGNED-SHORT");
    public static final DataType WIDGETHANDLE = new DataType(856, "WIDGET-HANDLE");

    public DataType() {
    }

    private DataType(int tokenType, String progressName) {
        this.tokenType = new Integer(tokenType);
        this.progressName = progressName;
        nameMap.put(progressName, this);
        tokenTypeMap.put(this.tokenType, this);
    }

    public static DataType getDataType(int tokenType) {
        return tokenTypeMap.get(new Integer(tokenType));
    }

    public static DataType getDataType(String progressCapsName) {
        return nameMap.get(progressCapsName);
    }

    public String getProgressName() {
        return this.progressName;
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public String toString() {
        return this.progressName;
    }

    public void writeXferBytes(DataXferStream out) throws IOException {
        out.writeRef(this.progressName);
        out.writeInt(this.tokenType);
    }

    public void writeXferSchema(DataXferStream out) throws IOException {
        out.schemaRef("progressName");
        out.schemaInt("tokenType");
    }
}

