/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import com.joanju.DataXferStream;
import java.io.IOException;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.Schema;
import org.prorefactor.treeparser.DataType;
import org.prorefactor.treeparser.Primative;
import org.prorefactor.treeparser.Symbol;
import org.prorefactor.treeparser.SymbolScope;
import org.prorefactor.treeparser.TableBuffer;

public class FieldBuffer
extends Symbol
implements Primative {
    Field field;
    TableBuffer buffer;

    public FieldBuffer() {
    }

    public FieldBuffer(SymbolScope scope, TableBuffer buffer, Field field) {
        super(scope);
        this.buffer = buffer;
        this.field = field;
        buffer.addFieldBuffer(this);
    }

    public void assignAttributesLike(Primative likePrim) {
        this.field.assignAttributesLike(likePrim);
    }

    public boolean canMatch(Field.Name input) {
        assert (input.generateName().toLowerCase().equals(input.generateName()));
        Field.Name self = new Field.Name(this.fullName().toLowerCase());
        if (input.db != null) {
            Schema schema = Schema.getInstance();
            if (this.buffer.getTable().getDatabase() != schema.lookupDatabase(input.db)) {
                return false;
            }
        }
        if (input.table != null && (this.buffer.isDefaultSchema() ? !self.table.startsWith(input.table) : !self.table.equals(input.table))) {
            return false;
        }
        return self.field.startsWith(input.field);
    }

    public Symbol copyBare(SymbolScope scope) {
        assert (false);
        return null;
    }

    public String fullName() {
        StringBuilder buff = new StringBuilder(this.buffer.fullName());
        buff.append(".");
        buff.append(this.field.getName());
        return buff.toString();
    }

    public TableBuffer getBuffer() {
        return this.buffer;
    }

    public String getClassName() {
        return this.field.getClassName();
    }

    public DataType getDataType() {
        return this.field.getDataType();
    }

    public int getExtent() {
        return this.field.getExtent();
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.field.getName();
    }

    public int getProgressType() {
        return 265;
    }

    public boolean isExported() {
        return this.buffer.isExported();
    }

    public boolean isImported() {
        return this.buffer.isImported();
    }

    public Primative setClassName(String className) {
        this.field.setClassName(className);
        return this;
    }

    public Primative setClassName(JPNode typeNameNode) {
        this.field.setClassName(typeNameNode);
        return this;
    }

    public Primative setDataType(DataType dataType) {
        this.field.setDataType(dataType);
        return this;
    }

    public Primative setExtent(int extent) {
        this.field.setExtent(extent);
        return this;
    }

    public void setName(String name) {
        assert (false);
    }

    public void writeXferBytes(DataXferStream out) throws IOException {
        super.writeXferBytes(out);
        out.writeRef(this.buffer);
        out.writeRef(this.field);
    }

    public void writeXferSchema(DataXferStream out) throws IOException {
        super.writeXferSchema(out);
        out.schemaRef("buffer");
        out.schemaRef("field");
    }
}

