/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import com.joanju.DataXferStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.schema.Field;
import org.prorefactor.treeparser.FieldBuffer;
import org.prorefactor.treeparser.Symbol;
import org.prorefactor.treeparser.SymbolScope;
import org.prorefactor.treeparser.Variable;
import org.prorefactor.treeparser.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldContainer
extends Widget {
    private ArrayList<JPNode> statementList = new ArrayList();
    private HashSet<FieldBuffer> fieldSet = new HashSet();
    private HashSet<Symbol> enabledFields = new HashSet();
    private HashSet<Symbol> otherSymbols = new HashSet();
    private HashSet<Variable> variableSet = new HashSet();

    protected FieldContainer() {
    }

    public FieldContainer(String name, SymbolScope scope) {
        super(name, scope);
    }

    public void addStatement(JPNode node) {
        this.statementList.add(node);
    }

    public void addSymbol(Symbol symbol, boolean statementIsEnabler) {
        if (symbol instanceof FieldBuffer) {
            this.fieldSet.add((FieldBuffer)symbol);
        } else if (symbol instanceof Variable) {
            this.variableSet.add((Variable)symbol);
        } else {
            this.otherSymbols.add(symbol);
        }
        if (statementIsEnabler) {
            this.enabledFields.add(symbol);
        }
    }

    public ArrayList<Symbol> getAllFields() {
        ArrayList<Symbol> ret = new ArrayList<Symbol>();
        ret.addAll(this.variableSet);
        ret.addAll(this.fieldSet);
        return ret;
    }

    public ArrayList<Symbol> getAllFieldsAndWidgets() {
        ArrayList<Symbol> ret = this.getAllFields();
        ret.addAll(this.otherSymbols);
        return ret;
    }

    public ArrayList<Symbol> getEnabledFields() {
        ArrayList<Symbol> ret = new ArrayList<Symbol>();
        ret.addAll(this.enabledFields);
        return ret;
    }

    public ArrayList<JPNode> getStatementList() {
        return this.statementList;
    }

    public Symbol lookupFieldOrVar(Field.Name name) {
        if (name.table == null) {
            for (Variable var : this.variableSet) {
                if (!var.getName().equalsIgnoreCase(name.field)) continue;
                return var;
            }
        }
        for (FieldBuffer fieldBuffer : this.fieldSet) {
            if (!fieldBuffer.canMatch(name)) continue;
            return fieldBuffer;
        }
        return null;
    }

    @Override
    public void writeXferBytes(DataXferStream out) throws IOException {
        super.writeXferBytes(out);
        out.writeRef(this.enabledFields);
        out.writeRef(this.fieldSet);
        out.writeRef(this.statementList);
        out.writeRef(this.variableSet);
        out.writeRef(this.otherSymbols);
    }

    @Override
    public void writeXferSchema(DataXferStream out) throws IOException {
        super.writeXferSchema(out);
        out.schemaRef("enabledFields");
        out.schemaRef("fieldSet");
        out.schemaRef("statementList");
        out.schemaRef("variableSet");
        out.schemaRef("otherSymbols");
    }
}

