/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import com.joanju.proparse.DoParse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.PRCException;
import org.prorefactor.macrolevel.IncludeRef;
import org.prorefactor.macrolevel.ListingParser;
import org.prorefactor.macrolevel.MacroLevel;
import org.prorefactor.macrolevel.MacroRef;
import org.prorefactor.nodetypes.ProgramRootNode;
import org.prorefactor.refactor.FileStuff;
import org.prorefactor.refactor.PUB;
import org.prorefactor.refactor.RefactorException;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.treeparser.IJPTreeParser;
import org.prorefactor.treeparser.SymbolScopeRoot;
import org.prorefactor.treeparser.TreeParserWrapper;
import org.prorefactor.treeparser01.TP01Action;
import org.prorefactor.treeparser01.TreeParser01;

public class ParseUnit {
    public static final int CONNECTED = 0;
    public static final int DEFAULT = 0;
    public static final int DISCONNECTED = 2;
    protected int style = 0;
    protected File file;
    private IncludeRef macroGraph = null;
    private ProgramRootNode topNode;
    protected PUB pub = null;
    protected RefactorSession refpack = RefactorSession.getInstance();
    private SymbolScopeRoot rootScope;

    public ParseUnit(File file) {
        this.file = file;
    }

    public File getFile() {
        if (this.file == null) {
            if (this.topNode == null) {
                return null;
            }
            this.file = new File(this.topNode.getFilenames()[0]);
        }
        return this.file;
    }

    public String[] getFileIndex() {
        if (this.topNode == null) {
            return null;
        }
        return this.topNode.getFilenames();
    }

    public IncludeRef getMacroGraph() throws RefactorException, IOException {
        if (this.macroGraph != null) {
            return this.macroGraph;
        }
        this.getPUB();
        if (!this.pub.isChecked()) {
            this.pub.loadTo(15);
        }
        if (!this.pub.isCurrent()) {
            this.pub.build();
        } else {
            try {
                FileInputStream fileIn = new FileInputStream(this.macroGraphFile());
                ObjectInputStream in = new ObjectInputStream(fileIn);
                this.macroGraph = (IncludeRef)in.readObject();
                in.close();
                fileIn.close();
            }
            catch (Exception e) {
                throw new RefactorException(e);
            }
        }
        return this.macroGraph;
    }

    public MacroRef[] getMacroSourceArray() throws RefactorException, IOException {
        return MacroLevel.sourceArray(this.getMacroGraph());
    }

    public PUB getPUB() {
        if (this.pub == null) {
            this.pub = new PUB(FileStuff.fullpath(this.getFile()));
            this.pub.setParseUnit(this);
        }
        return this.pub;
    }

    public SymbolScopeRoot getRootScope() {
        return this.rootScope;
    }

    public ProgramRootNode getTopNode() {
        if (this.topNode == null && this.pub != null) {
            this.setTopNode(this.pub.getTree());
        }
        return this.topNode;
    }

    public void loadOrBuildPUB() throws RefactorException, IOException {
        this.getPUB();
        if (this.pub.load()) {
            this.setTopNode(this.pub.getTree());
            this.treeParser01();
        } else {
            this.pub.build();
        }
    }

    private File macroGraphFile() {
        return new File(String.valueOf(PUB.pubDirFileName(this.file.getAbsolutePath())) + ".msg");
    }

    public void parse() throws RefactorException {
        this.refpack.enableParserListing();
        DoParse doParse = new DoParse(this.file.getPath());
        try {
            doParse.doParse();
            ListingParser listingParser = new ListingParser(RefactorSession.getListingFileName());
            listingParser.parse();
            this.macroGraph = listingParser.getRoot();
            if (RefactorSession.getInstance().getProjectBinaraiesEnabled()) {
                File macroGraphFile = this.macroGraphFile();
                macroGraphFile.getParentFile().mkdirs();
                FileOutputStream fileOut = new FileOutputStream(macroGraphFile);
                ObjectOutputStream out = new ObjectOutputStream(fileOut);
                out.writeObject(this.macroGraph);
                out.close();
                fileOut.close();
            }
        }
        catch (Exception e) {
            throw new RefactorException(e);
        }
        this.setTopNode(doParse.getTopNode());
    }

    public ParseUnit setPUB(PUB pub) {
        this.pub = pub;
        if (pub.getParseUnit() != this) {
            pub.setParseUnit(this);
        }
        return this;
    }

    public void setRootScope(SymbolScopeRoot rootScope) {
        this.rootScope = rootScope;
    }

    public void setTopNode(JPNode topNode) {
        this.topNode = (ProgramRootNode)topNode;
    }

    public void treeParser(IJPTreeParser tp) throws RefactorException {
        if (this.getTopNode() == null) {
            this.parse();
        }
        try {
            TreeParserWrapper.run2(tp, this.getTopNode());
        }
        catch (PRCException e) {
            throw new RefactorException(e.getMessage(), e);
        }
    }

    public void treeParser01() throws RefactorException {
        if (this.getTopNode() == null) {
            this.parse();
        }
        TreeParser01 tp = new TreeParser01();
        tp.getActionObject().setParseUnit(this);
        this.treeParser(tp);
    }

    public void treeParser01(TP01Action action) throws RefactorException {
        if (this.getTopNode() == null) {
            this.parse();
        }
        TreeParser01 tp = new TreeParser01();
        tp.setActionObject(action);
        action.setParseUnit(this);
        this.treeParser(tp);
    }
}

