/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import com.joanju.DataXferStream;
import java.io.IOException;
import org.prorefactor.core.JPNode;
import org.prorefactor.treeparser.CQ;
import org.prorefactor.treeparser.SymbolI;
import org.prorefactor.treeparser.SymbolScope;
import org.prorefactor.treeparser.SymbolScopeRoot;
import org.prorefactor.treeparser.SymbolScopeSuper;

public abstract class Symbol
implements SymbolI {
    private int allRefsCount = 0;
    private int numReads = 0;
    private int numWrites = 0;
    private JPNode asNode;
    private JPNode defNode;
    private JPNode likeNode;
    private SymbolScope scope;
    private String name;

    protected Symbol() {
    }

    protected Symbol(int allRefsCount, JPNode asNode, JPNode defNode, JPNode likeNode, String name, int numReads, int numWrites, SymbolScope scope) {
        this.allRefsCount = allRefsCount;
        this.asNode = asNode;
        this.defNode = defNode;
        this.likeNode = likeNode;
        this.name = name;
        this.numReads = numReads;
        this.numWrites = numWrites;
        this.scope = scope;
    }

    Symbol(SymbolScope scope) {
        this.scope = scope;
        scope.addSymbol(this);
    }

    public abstract Symbol copyBare(SymbolScope var1);

    public abstract String fullName();

    public int getAllRefsCount() {
        return this.allRefsCount;
    }

    public int getNumReads() {
        return this.numReads;
    }

    public int getNumWrites() {
        return this.numWrites;
    }

    public JPNode getAsNode() {
        return this.asNode;
    }

    public JPNode getDefineNode() {
        if (this.defNode != null && this.defNode.getType() != 913) {
            return this.defNode;
        }
        return null;
    }

    public JPNode getIndirectDefineIdNode() {
        if (this.defNode != null && this.defNode.getType() == 913) {
            return this.defNode;
        }
        return null;
    }

    public JPNode getLikeNode() {
        return this.likeNode;
    }

    public String getName() {
        return this.name;
    }

    public abstract int getProgressType();

    public SymbolScope getScope() {
        return this.scope;
    }

    public boolean isExported() {
        if (this.scope instanceof SymbolScopeSuper) {
            return true;
        }
        SymbolScopeRoot unitScope = this.scope.getRootScope();
        if (this.scope != unitScope) {
            return false;
        }
        if (unitScope.getClassName() != null) {
            if (this.defNode == null) {
                return false;
            }
            return this.defNode.findDirectChild(610) != null || this.defNode.findDirectChild(1116) != null;
        }
        if (this.defNode == null) {
            return false;
        }
        switch (this.defNode.getType()) {
            case 192: {
                return this.defNode.firstChild().getType() == 477;
            }
            case 310: 
            case 600: {
                return this.defNode.findDirectChild(594) == null;
            }
        }
        return false;
    }

    public boolean isImported() {
        if (this.defNode == null || this.defNode.getType() != 192) {
            return false;
        }
        return this.defNode.firstChild().getType() == 722;
    }

    public void noteReference(int contextQualifier) {
        ++this.allRefsCount;
        if (CQ.isRead(contextQualifier)) {
            ++this.numReads;
        }
        if (CQ.isWrite(contextQualifier)) {
            ++this.numWrites;
        }
    }

    public void setAsNode(JPNode asNode) {
        this.asNode = asNode;
    }

    public void setDefOrIdNode(JPNode node) {
        this.defNode = node;
    }

    public void setLikeNode(JPNode likeNode) {
        this.likeNode = likeNode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.fullName();
    }

    public void writeXferBytes(DataXferStream out) throws IOException {
        out.writeInt(this.allRefsCount);
        out.writeRef(this.asNode);
        out.writeRef(this.defNode);
        out.writeBool(this.isExported());
        out.writeBool(this.isImported());
        out.writeRef(this.likeNode);
        out.writeRef(this.name);
        out.writeInt(this.numReads);
        out.writeInt(this.numWrites);
        out.writeRef(this.scope);
    }

    public void writeXferSchema(DataXferStream out) throws IOException {
        out.schemaInt("allRefsCount");
        out.schemaRef("asNode");
        out.schemaRef("defNode");
        out.schemaBool("isExported");
        out.schemaBool("isImported");
        out.schemaRef("likeNode");
        out.schemaRef("name");
        out.schemaInt("numReads");
        out.schemaInt("numWrites");
        out.schemaRef("scope");
    }
}

